#include <string>
#include <QInputDialog>
#include <QPainter>
#include <QGridLayout>
#include <QToolButton>
#include <QSettings>
#include <libprofile.h>
#include <dbus/dbus.h>

#include "mainwidget.h"

using namespace std;

char iconNames[][128] = {
    "/usr/share/icons/hicolor/48x48/hildon/statusarea_silent.png",
    "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel4.png"
};

MainWidget::MainWidget (QWidget *parent)
    : QWidget(parent)
{
    // reset settings to defaults
//    AdvSettingsDlg asd(this);

    layout = new QGridLayout(this);

    settings = new QSettings(this);
            
    button = new QToolButton(this);
    refreshIcon();
    
    button->setSizePolicy(QSizePolicy::MinimumExpanding,
            QSizePolicy::MinimumExpanding);
    layout->addWidget(button, 0%2, 0/2);

    connect(button, SIGNAL(clicked()), this, SLOT(changeProfile()));
    setContentsMargins(0, 0, 0, 0);
    layout->setContentsMargins(0, 0, 0, 0);
    setLayout(layout);
    setAttribute(Qt::WA_TranslucentBackground);
    setAttribute(Qt::WA_OpaquePaintEvent);
    resize();
}

MainWidget::~MainWidget()
{
    delete settings;
}

void MainWidget::refreshIcon() {
    if ( string( profile_get_profile() ) == "silent" ) {
        changeIcon(1); 
    }
    else {
        changeIcon(0);
    }
}
    

void MainWidget::changeIcon(unsigned index) {
    button->setIcon(QIcon(QString(
        settings->value(QString("buttonIcon") + QString::number(0),  
        iconNames[index]).toString())));    
}

void MainWidget::switchProfile() {
    if ( string(profile_get_profile()) == "general" ) {
        profile_set_profile("silent");
    }
    else {
        profile_set_profile("general");
    }
}  

void MainWidget::changeProfile() {
    switchProfile();
    refreshIcon();
}

void MainWidget::paintEvent(QPaintEvent *)
{
    int bgAlpha = settings->value("bgAlpha", "192").toInt();
    QPainter p(this);
    p.fillRect(rect(), QColor(0, 0, 0, bgAlpha));
    p.end();
}

void MainWidget::resize()
{
    int w = settings->value("width", "48").toInt();
    int h = settings->value("height", "48").toInt();
    if (w < 1)
        w = 48;
    if (h < 1)
        h = 48;
    QWidget::resize(w, h);
}


