/*
 *  presence notifier statusbar plugin.
 *  Copyright (C) 2011 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _PRESENCE_NOTIFIER_SP_H_
#define _PRESENCE_NOTIFIER_SP_H_

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define TYPE_PRESENCE_NOTIFIER_STATUS_PLUGIN (presence_notifier_status_plugin_get_type())

#define PRESENCE_NOTIFIER_STATUS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), \
								  TYPE_PRESENCE_NOTIFIER_STATUS_PLUGIN, PresenceNotifierStatusPlugin))

#define PRESENCE_NOTIFIER_STATUS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), \
								       TYPE_PRESENCE_NOTIFIER_STATUS_PLUGIN, StatusPluginClass))

#define IS_PRESENCE_NOTIFIER_STATUS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
								     TYPE_PRESENCE_NOTIFIER_STATUS_PLUGIN))

#define IS_PRESENCE_NOTIFIER_STATUS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
									   TYPE_PRESENCE_NOTIFIER_STATUS_PLUGIN))
typedef struct _PresenceNotifierStatusPlugin PresenceNotifierStatusPlugin;
typedef struct _PresenceNotifierStatusPluginClass PresenceNotifierStatusPluginClass;
typedef struct _PresenceNotifierStatusPluginPrivate PresenceNotifierStatusPluginPrivate;

struct _PresenceNotifierStatusPlugin
{
  HDStatusMenuItem parent;
  PresenceNotifierStatusPluginPrivate* priv;
};

struct _PresenceNotifierStatusPluginClass
{
  HDStatusMenuItemClass parent;
};

GType presence_notifier_status_plugin_get_type(void);

G_END_DECLS

#endif
