#ifndef _PDL_H_
#define _PDL_H_

#include <SDL_stdinc.h>

#define PDL_FALSE SDL_FALSE
#define PDL_TRUE SDL_TRUE

typedef enum {
	PDL_NOERROR = 0,
	PDL_EMEMORY = 1,
	PDL_ECONNECTION = 2,
	PDL_INVALIDINPUT = 3,
	PDL_EOTHER = 4,
	PDL_UNINIT = 5,
	PDL_NOTALLOWED = 6,
	PDL_LICENSEFAILURE = 7,
	PDL_STRINGTOOSMALL = 8,
	PDL_SYSTEMERROR_FILE = 9,
	PDL_SYSTEMERROR_NET = 10,
	PDL_APPINFO = 11
} PDL_Err;

typedef enum {
	PDL_ORIENTATION_0 = 0,
	PDL_ORIENTATION_90 = 1,
	PDL_ORIENTATION_180 = 2,
	PDL_ORIENTATION_270 = 3
} PDL_Orientation;

typedef enum {
	PDL_AGGRESSION_LESSTOUCHES = 0,
	PDL_AGGRESSION_MORETOUCHES = 1
} PDL_TouchAggression;

typedef SDL_bool PDL_bool;

PDL_Err PDL_BannerMessagesEnable(PDL_bool Enable);
PDL_Err PDL_CustomPauseUiEnable(PDL_bool Enable);
PDL_Err PDL_GetLanguage(char *buffer, int bufferLen);
PDL_Err PDL_LaunchBrowser(const char* Url);
PDL_Err PDL_NotifyMusicPlaying(PDL_bool MusicPlaying);
PDL_Err PDL_ScreenTimeoutEnable(PDL_bool Enable);
PDL_Err PDL_SetOrientation(PDL_Orientation orientation);

#endif
