  # "Hildon Tutorial" version 2009-04-28
   # Example 2.1, "Example of stackable windows"
   
import gtk
import hildon
import sys
import PrayerTime
import GPSPrayerLocator

class prayertimeGTK:
    def show_new_window(self,widget):
         # Create the main window
         win = hildon.StackableWindow()
         win.set_title("Subview")
     
         # Setting a label in the new window
         label = gtk.Label("This is a subview")
     
         vbox = gtk.VBox(False, 0)
         vbox.pack_start(label, True, True, 0)
     
         win.add(vbox)
     
         # This call show the window and also add the window to the stack
         win.show_all()
    def main(self):
         self.tz = "0"
         self.lng = "0"
         self.lat = "0"
         self.loc = "None"
         
         
         program = hildon.Program.get_instance()
         
         # Create the main window
         win = hildon.StackableWindow()
         

         win.set_title("Main window")
         menu = self.create_menu()
       
           # Attach menu to the window
         win.set_app_menu(menu)
    
     
         button = gtk.Button("Go to subview")
         #win.add(button)
         self.pan = hildon.PannableArea()
         self.names = ['Fajr', 'Shorooq', 'Zohr', 'Asr', 'Maghrab','sunset', 'Eshaa']
         
         self.prayerTime = PrayerTime.Calculation() 
         self.loadSettings()
         print self.mode
         if(self.mode == None or self.mode == "None"):
            times = self.prayerTime.calculate()
         elif(self.mode == "GPS"):
            #a= "z"
            locator = GPSPrayerLocator.GPSPrayerLocator()
            locator.locate(self.refresh)
         elif(self.mode == "MAN"):
            times = self.prayerTime.calculate(int(self.tz),float(self.lat),float(self.lng))
         self.vbox = gtk.VBox()
         header = gtk.Label("PrayerTimes")
         self.vbox.pack_start(header)
         self.prayerTab = self.create_layout_tab(times,self.names)
         self.vbox.pack_start(self.prayerTab)
         #self.pan.add_with_viewport(self.vbox)
         win.add(self.vbox)
         
         button.connect("clicked", self.showWizerd)
     
         win.connect("destroy", gtk.main_quit, None)
     
         # This call show the window and also add the window to the stack
         win.show_all()
         gtk.main()
    def formatTime(self,time):
        return self.twoDigitsFormat(time.hour)+':'+ self.twoDigitsFormat(time.minute);
        
    def twoDigitsFormat(self,num):
            if(num < 10):
                return "0" + str(int(num))
            return str(int(num))
    def create_layout_tab(self,times,names):
        table = gtk.Table(2,3)
        j = 0 
        for i in xrange(0,7):
          label1 = gtk.Label(names[i])
          label2 = gtk.Label(self.formatTime(times[i]))
          table.attach(label1,0,1,i,i+1)
          table.attach(label2,1,2,i,i+1)
        return table
     
    def create_menu(self):
        menu = hildon.AppMenu()
    
        
        button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        command_id = "Location Settings"
        button.set_label(command_id)
        
            # Attach callback to clicked signal
        button.connect("clicked", self.show_settings_window)
        menu.append(button)
        
        button = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        command_id = "GPS"
        button.set_label(command_id)

        button.connect("clicked", self.saveGPS)
        
        menu.append(button)
        
        menu.show_all()
        
        return menu
    
    def show_settings_window(self,widget):
           # Create the main window
           win = hildon.StackableWindow()
           win.set_title("Settings")
           vbox = gtk.VBox(False, 0)
           
           self.entryLoc = hildon.Entry(gtk.HILDON_SIZE_AUTO)
           self.entryLoc.set_placeholder("Location Name")
           label = gtk.Label("Location")
           hbox = gtk.HBox()
           hbox.pack_start(label)
           hbox.pack_start(self.entryLoc)
           vbox.pack_start(hbox, True, True, 0)
           
           self.entryLat = hildon.Entry(gtk.HILDON_SIZE_AUTO)
           self.entryLat.set_placeholder("Latitude")
           label = gtk.Label("Latitude")
           hbox = gtk.HBox()
           hbox.pack_start(label)
           hbox.pack_start(self.entryLat)
           vbox.pack_start(hbox, True, True, 0)
           
           self.entryLong = hildon.Entry(gtk.HILDON_SIZE_AUTO)
           self.entryLong.set_placeholder("Longtude")
           label = gtk.Label("Longtude")
           hbox = gtk.HBox()
           hbox.pack_start(label)
           hbox.pack_start(self.entryLong)
           vbox.pack_start(hbox, True, True, 0)
           
           self.entryTZ = hildon.Entry(gtk.HILDON_SIZE_AUTO)
           self.entryTZ.set_placeholder("TimeZone")
           label = gtk.Label("timezone")
           hbox = gtk.HBox()
           hbox.pack_start(label)
           hbox.pack_start(self.entryTZ)
           vbox.pack_start(hbox, True, True, 0)
       
           self.loadSettings()
           
           self.entryLoc.set_text(self.loc)
           self.entryLat.set_text(self.lat)
           self.entryLong.set_text(self.lng)
           self.entryTZ.set_text(self.tz)
           
           button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                                  hildon.BUTTON_ARRANGEMENT_VERTICAL)
       
           # Set labels value
           button.set_text("Save", "apply Settings")
           
           vbox.pack_start(button, True, True, 0)
           
           button.connect("clicked", self.saveSettings)
           
           win.add(vbox)
       
           # This call show the window and also add the window to the stack
           win.show_all()
           self.settingsWin = win

           

    def loadSettings(self):
        self.mode = "None"
        settingsFile = open('settings', 'r')
        val = settingsFile.readline()
        if (val == ""):
            return None
        if(val == "1"):
            self.mode = "GPS"
    
        val = settingsFile.readline()
        if (val == ""):
            return None
        self.loc = val[0:len(val)-1];
        
        
        val = settingsFile.readline()
        if (val == ""):
            return None
        self.lat = val[0:len(val)-1]
        
        
        val = settingsFile.readline()
        if (val == ""):
            return None
        self.lng = val[0:len(val)-1]
        
        
        val = settingsFile.readline()
        if (val == ""):
            return None
        self.tz = val[0:len(val)-1]
        
        
        
        self.mode="MAN"

    def on_page_switch(self,notebook, page, num, dialog):
         print >>sys.stderr, "Page %d" % num
         return True
     
    def some_page_func(self,nb, current, userdata):
         # Validate data only for the third page.
         if current == 2:
             entry = nb.get_nth_page(current)
             return len(entry.get_text()) != 0
         else:
             return True
     
    def saveSettings(self,x):
        self.fileLocation = "/home/user/MyDocs/pyprayertimes/"
        settingsFile = open('settings', 'w')
        settingsFile.write("0\n")
        settingsFile.write(self.entryLoc.get_text()+"\n")
        settingsFile.write(self.entryLat.get_text()+"\n")
        settingsFile.write(self.entryLong.get_text()+"\n")
        settingsFile.write(self.entryTZ.get_text()+"\n")
        self.refresh(self.entryTZ.get_text(),self.entryLat.get_text(),self.entryLong.get_text())
        self.settingsWin.hide()
    
    def saveGPS(self,x):
        
        self.fileLocation = "/home/user/MyDocs/pyprayertimes/"
        settingsFile = open('settings', 'w')
       
        if(x.get_active()):
            settingsFile.write("1\n")
            locator = GPSPrayerLocator.GPSPrayerLocator()
            locator.locate(self.refresh)
        else:
            settingsFile.write("0\n")
        settingsFile.write(self.loc+"\n")
        settingsFile.write(self.lat+"\n")
        settingsFile.write(self.lng+"\n")
        settingsFile.write("0\n")
        
        
    def showWizerd(self,widget):
         # Create a notebook
         notebook = gtk.Notebook()
     
         # Create widgets to palce into the notebook's pages
         label_1 = gtk.Label("Page 1")
         label_2 = gtk.Label("Page 2")
     
         entry_3 = hildon.Entry(gtk.HILDON_SIZE_AUTO)
         entry_3.set_placeholder("Write something to continue")
     
         label_4 = gtk.Label("Page 4")
     
         # Append pages
         notebook.append_page(label_1, None)
         notebook.append_page(label_2, None)
         notebook.append_page(entry_3, None)
         notebook.append_page(label_4, None)
     
         # Create wizard dialog
         dialog = hildon.WizardDialog(None, "Wizard", notebook)
     
         # Set a handler for "switch-page" signal
         notebook.connect("switch-page", on_page_switch, dialog)
     
         # Set a function to decide if user can go to next page
         dialog.set_forward_page_func(some_page_func)
     
         dialog.show_all()
         dialog.run()
    def refresh(self,tz,lat,lng):
        self.vbox.remove(self.prayerTab)
        self.tz = tz
        self.lng = lng
        self.lat = lat
        times = self.prayerTime.calculate(int(self.tz),float(self.lat),float(self.lng))
        self.prayerTab = self.create_layout_tab(times,self.names)
        self.vbox.pack_start(self.prayerTab)
        self.vbox.show_all()
        #self.pan.remove(self.vbox)
        #self.pan.redraw(True)
        
        
        

if __name__ == "__main__":
     ui = prayertimeGTK()
     ui.main()