'''
Created on Mar 16, 2010

@author: maemo
'''

import UtilsSun  
import math
import datetime
from GPSPrayerLocator import GPSPrayerLocator
from UtilsSun import SunUtil

class Calculation(object):
    '''
    classdocs
    '''
    '''
    this.methodParams = new Array();

    /*  this.methodParams[methodNum] = new Array(fa, ms, mv, is, iv);    
    
            fa : fajr angle
            ms : maghrib selector (0 = angle; 1 = minutes after sunset)
            mv : maghrib parameter value (in angle or minutes)
            is : isha selector (0 = angle; 1 = minutes after maghrib)
            iv : isha parameter value (in angle or minutes)
    */

    this.methodParams[this.Jafari]    = new Array(16, 0, 4, 0, 14);        
    this.methodParams[this.Karachi]    = new Array(18, 1, 0, 0, 18);        
    this.methodParams[this.ISNA]    = new Array(15, 1, 0, 0, 15);        
    this.methodParams[this.MWL]        = new Array(18, 1, 0, 0, 17);        
    this.methodParams[this.Makkah]    = new Array(19, 1, 0, 1, 90);        
    this.methodParams[this.Egypt]    = new Array(19.5, 1, 0, 0, 17.5);        
    this.methodParams[this.Tehran]    = new Array(17.7, 0, 4.5, 0, 15);        
    this.methodParams[this.Custom]    = new Array(18, 1, 0, 0, 17);        
    '''

    def dayPortion(self,times):
        for i in xrange(0,7):
            times[i] = times[i]/24.0
        return times;

    def computeTimes(self,times=[],today=datetime.date.today(),lat=30.13,lng= 31.40,tz=2):
        self.lat = lat
        self.lng = lng
        self.tz = tz
        t = self.dayPortion(times);
        utils = UtilsSun.SunUtil()
        utils.initZone(float(today.year), float(today.month), float(today.day),lat, lng, tz)
        Fajr    = utils.computeTime((180- 19.5), t[0]);
        Sunrise = utils.computeTime(180- 0.833, t[1])
        Dhuhr   = utils.computeMidDay(t[2])
        Asr     = self.computeAsr(1, t[3],utils)
        Sunset  = utils.computeTime(0.833, t[4])
        Maghrib = utils.computeTime(4, t[5])
        Isha    = utils.computeTime(17.5, t[6])
        return [Fajr, Sunrise, Dhuhr,Asr, Sunset,Maghrib, Isha]

    def computeAsr(self,step, t,utils): 
        D = utils.sunDeclination(utils.JDate+ t);
        G = -utils.darccot(step+ utils.dtan(math.fabs(self.lat-D)));
        return utils.computeTime(G, t);
    
    def __init__(self):
        '''
        Constructor
     
        '''
    
    def computeDayTimes(self,today,lat,lng,tz):
        self.lat = lat
        self.lng = lng
        self.tz = tz
        times = [5.0, 6.0, 12.0, 13.0, 18.0, 18.0, 18.0]#; //default times
        
        times = self.computeTimes(times,today);
    
        times = self.adjustTimes(times,tz,lng);
        times = self.adjustTimesFormat(times)
        return times;

    def test2(self):
        today = datetime.date.today()
        print self.computeDayTimes(today)
    def adjustTimes(self,times,tz,lng):
        for i in xrange(0,7):
            times[i] += tz- lng/ 15;
    #times[2] += 0/ 60; //Dhuhr
    #if (self.methodParams[this.calcMethod][1] == 1) // Maghrib
     #   times[5] = times[4]+ this.methodParams[this.calcMethod][2]/ 60;
    #if (this.methodParams[this.calcMethod][3] == 1) // Isha
       # times[6] = times[5]+ this.methodParams[this.calcMethod][4]/ 60;
        return times
        
      
    def adjustTimesFormat(self,times):
        for i in xrange(0,7):
                times[i] = self.floatToTime24(times[i]);
        return times;
    
    def floatToTime24(self,time):
        utils = SunUtil()
        time = utils.fixhour(time+ 0.5/ 60)#;  // add 0.5 minutes to round
        hours = math.floor(time); 
        minutes = math.floor((time- hours)* 60);
        return self.twoDigitsFormat(hours)+':'+ self.twoDigitsFormat(minutes);
        
    def twoDigitsFormat(self,num):
        if(num < 10):
            return "0" + str(int(num))
        return str(int(num))

    def calculatePrayerTimes(self,date = datetime.date.today(),gps = 0,tz=2,lat=30.13,lng= 31.40):
        if(gps == 1):
            self.date = date 
            self.tz = tz
            locator = GPSPrayerLocator()
            locator.useGPS(self)
        else:
             print self.computeDayTimes(date,lat,lng,tz)