#ifndef POWERMENUENTRYCREATOR_H
#define POWERMENUENTRYCREATOR_H

#include <QObject>
#include <QString>
#include <QtXml/QXmlStreamWriter>
#include <QFileInfo>

#include "DesktopFileScanner.h"


class PowerMenuEntryCreator : public QObject
{
    Q_OBJECT
    Q_ENUMS(EntryType)
public:
    Q_PROPERTY(int priority READ getPriority WRITE setPriority NOTIFY priorityChanged)
    Q_PROPERTY(QString desktopName READ getDesktopName WRITE setDesktopName NOTIFY desktopNameChanged)
    Q_PROPERTY(bool haveIcon READ getHaveIcon NOTIFY iconChanged)
    Q_PROPERTY(QString iconUrl READ getIconUrl WRITE setIconUrl NOTIFY iconChanged)
    Q_PROPERTY(QString appName READ getAppName WRITE setAppName NOTIFY appNameChanged)
    enum EntryType
    {
        LaunchApp = 0
    } entry;

    PowerMenuEntryCreator() : entry(LaunchApp), priority(500) {}
    PowerMenuEntryCreator(EntryType e) : entry(e), priority(500) {}

    Q_INVOKABLE inline int refreshSystemUI() { return system("killall systemui"); }
    Q_INVOKABLE inline bool removeEntry(QString file) { return QFile::remove(file); }
   // Q_INVOKABLE bool scanEntry(QString file);
    Q_INVOKABLE bool createEntry();
    Q_INVOKABLE inline void setEntryType(EntryType type) {entry = type;}
    //Q_INVOKABLE inline void setData(desktopDescriptor d) {appName = d.getAppName(); desktopName = d.getDesktop(); iconUrl = d.getIcon(); }
    Q_INVOKABLE inline void setData(QString an, QString dn, QString iu) {appName = an; desktopName = dn; iconUrl = iu;}
    inline QString stripFilename(QString filename) const { return QFileInfo(filename).baseName(); }

protected:
    int priority;
    QString desktopName, appName, // name visible to user and name of .desktop
            iconUrl;
    QXmlStreamWriter& writeLaunchAppCallback(QXmlStreamWriter& w);
    QString entryFileName() const;

    inline int getPriority() const {return priority;}
    inline QString getDesktopName() const {return desktopName;}
    inline bool getHaveIcon() const {return !iconUrl.isEmpty();}
    inline QString getIconUrl() const { return iconUrl; }
    inline QString getAppName() const {return appName; }

    inline void setPriority(int p) { priority = p; emit priorityChanged(p); }
    inline void setDesktopName(QString n) { desktopName = n; emit desktopNameChanged(n); }
    inline void setIconUrl(QString u) { iconUrl = u; emit iconChanged(u); }
    inline void setAppName(QString a) { appName = a; emit appNameChanged(a); }

signals:
    void priorityChanged(int p);
    void desktopNameChanged(QString n);
    void iconChanged(QString i);
    void appNameChanged(QString a);

};

#endif // POWERMENUENTRYCREATOR_H
