# (c) Copyright 2010, Николай Слободской (Nick Slobodsky)
# This file is part of PlansPlant.
#
# PlansPlant is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# PlansPlant is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
#
TEMPLATE = app
VERSION = 0.0.1

TARGET = plansplant

SOURCES = main.cpp

INCLUDEPATH += ../lib

LIBS += -L../lib -lplansplant

unix {
isEmpty( PREFIX ) {
  PREFIX = /usr/local
}

BINDIR = $${PREFIX}/bin
DATADIR = $${PREFIX}/share

target.path += $${BINDIR}
INSTALLS += target
# Menu item
maemo5 {
APPMENUSUBDIR = applications/hildon
# Desktop file translation
gettextfile.target = lang/plansplant.desktop.ru.mo
gettextfile.depends = lang/plansplant.desktop.ru.po
gettextfile.commands = msgfmt -o $${gettextfile.target} $${gettextfile.depends}
QMAKE_EXTRA_TARGETS += gettextfile
POST_TARGETDEPS += $${gettextfile.target}
QMAKE_CLEAN += $${gettextfile.target}
gettextfile.path = $${DATADIR}/locale/ru/LC_MESSAGES
gettextfile.extra = $(INSTALL_FILE) $${gettextfile.target} $(INSTALL_ROOT)$${gettextfile.path}/$${TARGET}.desktop.mo
INSTALLS += gettextfile
}
else {
APPMENUSUBDIR = applications
}
appmenu.target = $${TARGET}.desktop
appmenu.depends = $${appmenu.target}.in
appmenu.commands = sed s\|@BINDIR@\|$${BINDIR}\| < $${appmenu.depends} > $${appmenu.target}
QMAKE_EXTRA_TARGETS += appmenu
POST_TARGETDEPS += $${appmenu.target}
QMAKE_CLEAN += $${appmenu.target}
appmenu.path = $${DATADIR}/$${APPMENUSUBDIR}
appmenu.extra = $(INSTALL_FILE) plansplant.desktop $(INSTALL_ROOT)$${appmenu.path}/$${TARGET}.desktop
INSTALLS += appmenu
} # unix

