#include "EMail.h"

#include "../Database.h"

#include "../Data/EMail.h"

#include <Lum/Base/Util.h>

#include <Lum/Model/Selection.h>

#include <Lum/Label.h>
#include <Lum/Text.h>

#include <iostream>

namespace Views {

  EMail::EMail()
  : DataView(L"EMail")
  {
    address=new Lum::Model::String();

    RegisterModel(address);
  }

  void EMail::RegisterDataViews(Lum::Tab*& tab)
  {
    tab->Add(L"EMail",Lum::VPanel::Create(true,true)
             ->Add(Lum::Label::Create(true,false)
                   ->AddLabel(L"EMail",Lum::String::Create(address,true,false))));

    DataView::RegisterDataViews(tab);
  }

  void EMail::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==saveAction && saveAction->IsFinished()) {
      if (!email->IsRegistered()) {
        database->Insert(email);

        if (viewData->RequestsLink()) {
          viewData->linkData->LinkData(viewData->linkName,email);
          viewData->ClearLinkInfo();
          RefreshLinkTable();
        }
      }
      Save();
    }
    else if (IsRegisteredModel(model)) {
      if (!address->Empty()) {
        saveAction->Enable();
      }
      else {
        saveAction->Disable();
      }
    }
    else {
      DataView::Resync(model,msg);
    }
  }

  void EMail::Load(DataPtr viewData)
  {
    SetViewData(viewData);

    email=dynamic_cast< ::Data::EMail*>(viewData->data);

    assert(email!=NULL);

    address->Set(email->email);

    DataView::Load(viewData);
  }

  void EMail::Vanish()
  {
    DataView::Vanish();

    email=NULL;
  }

  void EMail::Save()
  {
    email->email=address->Get();
  }
}
