#include "MultiView.h"

MultiView::MultiView()
: hidden(NULL),
  current(NULL)
{
  // no code
}

MultiView::~MultiView()
{
  // TODO
}

bool MultiView::VisitChildren(Lum::Visitor &visitor, bool onlyVisible)
{
  std::list<Base::View*>::iterator iter;

  if (onlyVisible) {
    if (current!=NULL && !visitor.Visit(current)) {
      return false;
    }
  }
  else {
    iter=views.begin();
    while (iter!=views.end()) {
      if (!visitor.Visit(*iter)) {
        return false;
      }

      ++iter;
    }
  }

  return true;
}

void MultiView::CalcSize()
{
  std::list<Base::View*>::iterator iter;

  minWidth=0;
  minHeight=0;
  width=0;
  height=0;

  iter=views.begin();
  while (iter!=views.end()) {
    (*iter)->CalcSize();

    minWidth=std::max(minWidth,(*iter)->GetOMinWidth());
    minHeight=std::max(minHeight,(*iter)->GetOMinHeight());
    width=std::max(width,(*iter)->GetOWidth());
    height=std::max(height,(*iter)->GetOHeight());

    ++iter;
  }

  Group::CalcSize();
}

void MultiView::Layout()
{
  std::list<Base::View*>::iterator iter;

  iter=views.begin();
  while (iter!=views.end()) {
    (*iter)->Resize(width,height);
    (*iter)->Move(x+(width-(*iter)->GetOWidth())/2,
                  y+(height-(*iter)->GetOHeight())/2);

    ++iter;
  }
}

void MultiView::Draw(Lum::OS::DrawInfo* draw, int x, int y, size_t w, size_t h)
{
  if (hidden!=NULL) {
    draw->PushClipBegin(x,y,width,height);
    draw->SubClipRegion(x,y,width,height);
    draw->PushClipEnd();
    hidden->Hide();
    draw->PopClip();
    hidden->Vanish();
    hidden=NULL;
  }

  Lum::Group::Draw(draw,x,y,w,h);
}

void MultiView::AddView(Base::View* view)
{
  view->SetParent(this);
  view->SetFlex(true,true);

  views.push_back(view);
}

void MultiView::ShowView(const std::wstring& name, Base::View::Data* data)
{
  std::list<Base::View*>::iterator iter;

  iter=views.begin();
  while (iter!=views.end() && (*iter)->GetName()!=name) {
    ++iter;
  }

  assert (iter!=views.end());

  if ((*iter)!=current) {
    if (current!=NULL) {
      hidden=current;
    }

    current=(*iter);

    if (visible) {
      SetRelayout();
      Redraw();
    }

    current->Load(data);
  }
}
