#include "Search.h"

#include "../Database.h"

#include "../Data.h"

#include <Lum/Base/Util.h>

#include <Lum/Button.h>
#include <Lum/Menu.h>
#include <Lum/String.h>

#include <Lum/Model/Selection.h>

#include <iostream>

namespace Views {

  class DataEntryModelPainter : public Lum::StringCellPainter
  {
  public:
    std::wstring GetCellData() const
    {
      const DataEntry* entry=dynamic_cast<const DataEntryModel*>(GetModel())->GetEntry(GetRow());

      if (GetColumn()==1) {
        return entry->data->GetType()->GetName();
      }
      else if (GetColumn()==2) {
        return entry->data->GetDisplayText();
      }

      return L"";
    }
  };

  class DataEntryComparator : public DataEntryModel::Comparator
  {
  public:
    bool operator()(const DataEntryModel::ElementType& a,
                    const DataEntryModel::ElementType& b,
                    size_t column, bool down) const
    {
      if (a->data->GetType()->GetName()==b->data->GetType()->GetName()) {
        return a->data->GetDisplayText()<b->data->GetDisplayText();
      }
      else {
        return a->data->GetType()->GetName()<b->data->GetType()->GetName();
      }
    }
  };

  Search::Search()
  : View(L"Search"),
    viewAction(new Lum::Model::Action),
    searchAction(new Lum::Model::Action),
    model(new DataEntryModel(new DataEntryComparator())),
    searchValue(new Lum::Model::String()),
    table(NULL),top(NULL)
  {
    searchValue->Set(L"");

    Observe(viewAction);
    Observe(searchAction);
  }

  Search::~Search()
  {
    delete top;
  }

  void Search::FillList()
  {
    model->Off();

    model->Clear();

    if (searchValue->Get()!=L"") {
      ::Base::DataConstIterator iter;

      iter=database->database.begin();
      while (iter!=database->database.end()) {
        for (size_t x=0; x<=(*iter)->GetType()->GetMaxAttribute(); x++) {
          if ((*iter)->GetAttribute(x).find(searchValue->Get())!=std::string::npos) {
            model->Append(new DataEntry(*iter));
            break;
          }
        }

        iter++;
      }

      model->Sort(1);
    }

    model->On();
  }

  bool Search::VisitChildren(Lum::Visitor &visitor, bool onlyVisible)
  {
    if (top!=NULL) {
      return visitor.Visit(top);
    }

    return true;
  }

  void Search::CalcSize()
  {
    Lum::Menu             *menu;
    Lum::String           *string;
    Lum::Panel            *horiz;
    Lum::Model::HeaderRef headerModel;

    top=Lum::VPanel::Create(true,true);
    top->SetParent(this);

    horiz=Lum::HPanel::Create(true,false);

    string=Lum::String::Create(searchValue,true,false);
    string->SetReturnAction(searchAction);
    horiz->Add(string);

    horiz->Add(Lum::Button::Create(L"_Search",searchAction,false,true));

    top->Add(horiz);

    top->AddSpace();

    headerModel=new Lum::Model::HeaderImpl();
    headerModel->AddColumn(L"Type",Lum::Base::Size::stdCharWidth,8);
    headerModel->AddColumn(L"Description",Lum::Base::Size::stdCharWidth,50);

    table=new Lum::Table();
    table->SetFlex(true,true);
    table->SetShowHeader(true);
    table->SetModel(model);
    table->SetPainter(new DataEntryModelPainter());
    table->SetHeaderModel(headerModel);
    table->SetSelection(new Lum::Model::SingleLineSelection());
    table->SetDoubleClickAction(viewAction);

    menu=new Lum::Menu();
    menu->SetParent(GetWindow());
    menu->AddActionItem(L"View",viewAction);
    table->SetMenu(menu->GetWindow());

    top->Add(table);

    top->CalcSize();

    width=top->GetOWidth();
    height=top->GetOHeight();
    minWidth=top->GetOMinWidth();
    minHeight=top->GetOMinHeight();
    maxWidth=top->GetOMaxWidth();
    maxHeight=top->GetOMaxHeight();

    View::CalcSize();
  }

  void Search::Layout()
  {
    top->Resize(width,height);
    top->Move(x,y);

    View::Layout();
  }

  void Search::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==viewAction && viewAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t           line;
        Base::View::Data *data;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        data=new ::Base::View::Data(dynamic_cast< DataEntry*>(this->model->GetEntry(line))->data);
        GUI::GetInstance()->ShowView(data->data->GetType()->GetName(),data);
      }
    }
    else if (model==searchAction && searchAction->IsFinished()) {
      FillList();
    }
    else {
      View::Resync(model,msg);
    }
  }

  void Search::Load(::Base::View::DataPtr data=NULL)
  {
    FillList();
  }

  void Search::Vanish()
  {
    model->Clear();
  }
}
