#include "Person.h"

#include <assert.h>

namespace Data {
  Person::PersonType *Person::personType=new Person::PersonType();

  Person::PersonType::PersonType()
  : Type(L"Person")
  {
    RegisterAttribute(L"title",title);
    RegisterAttribute(L"surename",surename);
    RegisterAttribute(L"middlename",middlename);
    RegisterAttribute(L"name",name);
    RegisterAttribute(L"suffix",suffix);
    RegisterAttribute(L"nick",nick);
  }

  unsigned long Person::PersonType::GetMaxAttribute() const
  {
    return nick;
  }

  bool Person::PersonType::IsPrimaryType() const
  {
    return true;
  }

  ::Base::DataPtr Person::PersonType::Create() const
  {
    return new Person;
  }

  Person::Person()
   : Data(personType)
  {
    // no code
  }

  bool Person::IsGreater(Data* other) const
  {
    Person* tmp=dynamic_cast<Person*>(other);

    if (tmp==NULL) {
      return false;
    }
    else if (name!=tmp->name) {
      return name>tmp->name;
    }
    else if (surename!=tmp->surename) {
      return surename>tmp->surename;
    }
    else {
      return middlename>tmp->middlename;
    }
  }

  std::wstring Person::GetDisplayText() const
  {
    std::wstring res;

    if (!name.empty()) {
      if (!res.empty()) {
        res.append(L" ");
      }
      res.append(name);
    }
    res.append(L", ");

    if (!suffix.empty()) {
      if (!res.empty()) {
        res.append(L" ");
      }
      res.append(suffix);
    }

    if (!title.empty()) {
      if (!res.empty()) {
        res.append(L" ");
      }
      res.append(title);
    }

    if (!nick.empty()) {
      if (!res.empty()) {
        res.append(L" ");
      }
      res.append(L"\""+nick+L"\"");
    }

    if (!middlename.empty()) {
      if (!res.empty()) {
        res.append(L" ");
      }
      res.append(middlename);
    }

    if (!surename.empty()) {
      if (!res.empty()) {
        res.append(L" ");
      }
      res.append(surename);
    }

    return res;
  }

  void Person::SetAttribute(::Base::Id id, const std::wstring& value)
  {
    switch (id) {
    case PersonType::title:
      title=value;
      break;
    case PersonType::surename:
      surename=value;
      break;
    case PersonType::middlename:
      middlename=value;
      break;
    case PersonType::name:
      name=value;
      break;
    case PersonType::suffix:
      suffix=value;
      break;
    case PersonType::nick:
      nick=value;
      break;
    default:
      assert(false);
    }
  }

  std::wstring Person::GetAttribute(Base::Id id) const
  {
    switch (id) {
    case PersonType::title:
      return title;
    case PersonType::surename:
      return surename;
    case PersonType::middlename:
      return middlename;
    case PersonType::name:
      return name;
    case PersonType::suffix:
      return suffix;
    case PersonType::nick:
      return nick;
    default:
      assert(false);
    }
  }
}
