#include "Note.h"

#include <assert.h>

namespace Data {
  Note::NoteType *Note::noteType=new Note::NoteType();

  Note::NoteType::NoteType()
  : Type(L"Note")
  {
    RegisterAttribute(L"text",text);
  }

  unsigned long Note::NoteType::GetMaxAttribute() const
  {
    return text;
  }

  bool Note::NoteType::IsPrimaryType() const
  {
    return true;
  }

  ::Base::DataPtr Note::NoteType::Create() const
  {
    return new Note;
  }

  Note::Note()
   : Data(noteType)
  {
    // no code
  }

  std::wstring Note::GetDisplayText() const
  {
    size_t pos;

    pos=text.find(L'\n');
    if (pos!=std::wstring::npos) {
      return text.substr(0,pos)+L"...";
    }
    else {
      return text;
    }
  }

  void Note::SetAttribute(::Base::Id id, const std::wstring& value)
  {
    switch (id) {
    case NoteType::text:
      text=value;
      break;
    default:
      assert(false);
    }
  }

  std::wstring Note::GetAttribute(Base::Id id) const
  {
    switch (id) {
    case NoteType::text:
      return text;
    default:
      assert(false);
    }
  }

  bool Note::IsMultilineAttribute(Base::Id id) const
  {
    switch (id) {
    case NoteType::text:
      return true;
    default:
      return Data::IsMultilineAttribute(id);
    }
  }
}
