#ifndef VIEWS_DATE_H
#define VIEWS_DATE_H

#include "../View.h"

#include "../Data/Date.h"

#include <Lum/Model/Action.h>
#include <Lum/Model/Boolean.h>
#include <Lum/Model/Calendar.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Time.h>

#include <Lum/Panel.h>
#include <Lum/String.h>

namespace Views {

  class Date : public ::Base::DataView
  {
  private:
    ::Data::Date            *date;

    Lum::Panel              *panel;

    Lum::Model::StringRef   description;
    Lum::Model::CalendarRef startDate;
    Lum::Model::CalendarRef endDate;
    Lum::Model::SizeTRef    repeat;
    Lum::Model::CalendarRef repeatEndDate;
    Lum::Model::StringRef   repeatInterval;
    Lum::Model::BooleanRef  wholeDay;
    Lum::Model::TimeRef     startTime;
    Lum::Model::TimeRef     endTime;

  public:
    Date();

    void RegisterDataViews(Lum::Tab*& tab);

    void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

    void Load(::Base::View::DataPtr viewData=NULL);
    void Vanish();
    void Save();
  };

}

#endif
