#ifndef VIEWS_PEOPLE_H
#define VIEWS_PEOPLE_H

#include <list>

#include <Lum/Model/Table.h>

#include <Lum/Panel.h>
#include <Lum/Table.h>

#include "../GUI.h"

#include "../Data/Person.h"

namespace Views {

  class PeopleEntry
  {
  public:
    ::Data::PersonPtr person;

  public:
    PeopleEntry(::Data::PersonPtr person)
    : person(person)
    {
      // no code
    }
  };

  typedef Lum::Model::StdTable<PeopleEntry*>     PeopleEntryModel;
  typedef Lum::Base::Reference<PeopleEntryModel> PeopleEntryModelRef;

  class People : public ::Base::View
  {
  private:
    Lum::Model::ActionRef    viewAction;
    Lum::Model::ActionRef    addAction;
    Lum::Model::ActionRef    deleteAction;
    PeopleEntryModelRef      model;
    Lum::Table               *table;
    Lum::Panel               *top;

  private:
    void FillList();

  public:
    People();
    ~People();

    bool VisitChildren(Lum::Visitor &visitor, bool onlyVisible);

    void CalcSize();
    void Layout();

    void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

    void Load(DataPtr data);
    void Vanish();
  };
}

#endif
