#include "Person.h"

#include "../Database.h"

#include "../Data/Person.h"

#include <Lum/Base/Util.h>

#include <Lum/Model/Selection.h>

#include <Lum/Label.h>
#include <Lum/Text.h>

#include <iostream>

namespace Views {

  Person::Person()
  : DataView(L"Person")
  {
    title=new Lum::Model::String();
    surename=new Lum::Model::String();
    middlename=new Lum::Model::String();
    name=new Lum::Model::String();
    suffix=new Lum::Model::String();
    nick=new Lum::Model::String();

    RegisterModel(title);
    RegisterModel(surename);
    RegisterModel(middlename);
    RegisterModel(name);
    RegisterModel(suffix);
    RegisterModel(nick);
  }

  void Person::RegisterDataViews(Lum::Tab*& tab)
  {
    tab->Add(L"Person",
             Lum::VPanel::Create(true,true)
             ->Add(Lum::Label::Create(true,false)
                   ->AddLabel(L"Title",Lum::String::Create(title,true,false))
                   ->AddLabel(L"Surename",Lum::HPanel::Create(true,false)
                              ->Add(Lum::String::Create(surename,true,false))
                              ->AddSpace()
                              ->Add(new Lum::Text(L"Middlename"))
                              ->AddSpace()
                              ->Add(Lum::String::Create(middlename,true,false)))
                   ->AddLabel(L"Name",Lum::String::Create(name,true,false))
                   ->AddLabel(L"Suffix",Lum::HPanel::Create(true,false)
                              ->Add(Lum::String::Create(suffix,true,false))
                              ->AddSpace()
                              ->Add(new Lum::Text(L"Nick"))
                              ->AddSpace()
                              ->Add(Lum::String::Create(nick,true,false)))));

    DataView::RegisterDataViews(tab);
  }

  void Person::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==saveAction && saveAction->IsFinished()) {
      if (!person->IsRegistered()) {
        database->Insert(person);

        if (viewData->RequestsLink()) {
          viewData->linkData->LinkData(viewData->linkName,person);
          viewData->ClearLinkInfo();
          RefreshLinkTable();
        }
      }
      Save();
    }
    else if (IsRegisteredModel(model)) {
      if (!surename->Empty() || !name->Empty()) {
        saveAction->Enable();
      }
      else {
        saveAction->Disable();
      }
    }
    else {
      DataView::Resync(model,msg);
    }
  }

  void Person::Load(DataPtr viewData)
  {
    SetViewData(viewData);
    person=dynamic_cast< ::Data::Person*>(viewData->data);

    assert(person!=NULL);

    title->Set(person->title);
    surename->Set(person->surename);
    middlename->Set(person->middlename);
    name->Set(person->name);
    suffix->Set(person->suffix);
    nick->Set(person->nick);

    DataView::Load(viewData);
  }

  void Person::Vanish()
  {
    DataView::Vanish();

    person=NULL;
  }

  void Person::Save()
  {
    person->title=title->Get();
    person->surename=surename->Get();
    person->middlename=middlename->Get();
    person->name=name->Get();
    person->suffix=suffix->Get();
    person->nick=nick->Get();
  }
}
