#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QFile>
#include <QCoreApplication>
#include <QTextStream>
#include <QProcess>
#include <QtGui/QCloseEvent>
#include <QSettings>
#include <QDebug>
#include <QFileDialog>

//12-July-2011 - Issues with SPYCAM - it has to send raw image over network so if signal is crap - you get choppy image. Might need to do generating Xvid file.

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    videoyes = true; //so that sdpgen denerates the right file, when presed by itself.
    sdpgenerated = false;
    //cambackyes=false;
    ui->setupUi(this);
    debugclicked = false;
    vlcsdpgenerated = "";
    ui->labcust->hide();
    ui->custom1->hide();
    ui->outWind->hide();
    ui->sdpgen->hide();
    ui->stopsream->hide();
    ui->filesinkname->hide();
    ui->labfilenam->hide();
    ui->scpframe->setStyleSheet("QWidget { background-color: black;}");
    ui->labscpuser->setStyleSheet("QLabel {color : white;}");
    ui->labscppass->setStyleSheet("QLabel {color : white;}");
    ui->scpsend->setStyleSheet("QPushButton {background-color : white; color : black;}");
    ui->usernam->setStyleSheet("QLineEdit {background-color : white; color : black;}");
    ui->passwrd->setStyleSheet("QLineEdit {background-color : white; color : black;}");
    ui->scpbutton->hide();
    ui->scpframe->hide();
    ui->passwrd->setEchoMode(QLineEdit::Password);
    ui->port1->setValidator(new QIntValidator(0,9999, this));
    ui->vol->setValidator(new QIntValidator(0,9,this));
    ui->qcontrol->setValidator(new QIntValidator(0,100,this));
    helpScreen = true;  //show helpscreen
    ui->qcontrol->hide();
    applySettings();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::makeStream(QString host, bool backcamera, bool video, QString port, QString width, QString height, int outp){
    QString contextRun; QString messager;
    QString begbits;
    QString midbits;
    QString streamout;
    QString qbcam;
    QString Jquality;
    qDebug() << "making stream";

    if(ui->tickqual->isChecked()){Jquality= "quality="+ui->qcontrol->text();}else{Jquality="";}   //necessary because the option kills quality, even if 100%
    if(video){
        if(backcamera){ qbcam = "0"; } else { qbcam = "1";}
        if(fileyes){
            begbits ="filesrc location="+openfile+" ! decodebin !";
        } else if(!fileyes) {
            begbits="v4l2src device=/dev/video"+qbcam+" ! videoscale ! video/x-raw-yuv,width="+width+",height="+height+" ! ";
        }
        if(outp==4){ //filesink
            QString filelocation = ui->filesinkname->text();
            streamout = "gst-launch-0.10 v4l2src device=/dev/video"+qbcam+" ! videoscale ! video/x-raw-yuv,width="+width+",height="+height+" ! ffmpegcolorspace ! jpegenc "+Jquality+" ! avimux ! filesink location=/home/user/MyDocs/.videos/"+filelocation+".avi";
            notify("streaming to "+filelocation, false);
        }
        else if(outp==0){//http  //dont forget to delete file
            /////////////////////DOOOOOOOOOOOSOMMMEEEEEEEEEEETTTTTTHHHHHHHHIIIIIIIIINGGGGGGGGGGGGGGGGGGGGGGGGGGggg///////////////////
            QString exc = "#!/bin/bash\nread throwaway\nsleep 5\necho HTTP/1.0 200 Ok\necho Server: socat kludge\necho -n Date:\ndate\necho Content-Type: video/x-msvideo\necho Content-Length: 10000000\necho Last-Modified: Sun, 19 Jun 2011 22:53:20 GMT\necho Connection: close\necho\nrm -f /home/user/.tmpvid > /dev/null\nmkfifo /home/user/.tmpvid\ngst-launch-0.10vlc  "+begbits+"ffmpegcolorspace ! jpegenc"+Jquality+" ! filesink location=/home/user/.tmpvid >/dev/null &\ncat /home/user/.tmpvid";
            //QString wer = "#!/bin/bash\nread throwaway\nsleep 5\necho HTTP/1.0 200 Ok\necho Server: socat kludge\necho -n Date:\ndate\necho Content-Type: video/x-msvideo\necho Content-Length: 10000000\necho Last-Modified: Sun, 19 Jun 2011 22:53:20 GMT\necho Connection: close\necho\nrm -f /home/user/.tmmm >/dev/null\nmkfifo /home/user/.tmmm\ngst-launch "+begbits+" ffmpegcolorspace ! jpegenc "+Jquality+" ! filesink location=/home/user/.tmmm >/dev/null &\ncat /home/user/.tmmm";
            write2file("/home/user/.httpstream", exc);
            executable("/home/user/.httpstream");
            streamout = "socat TCP4-LISTEN:"+port+",reuseaddr,fork exec:/home/user/.httpstream";
            messager = "Open VLC:\nMedia-->Open Network Stream..., Type in:\nhttp://"+getIP()+":"+port;
            notify("streaming", false);
        }

        else if(outp!=0 || outp!=4){ //http or filesink? no   //this is neccasary because http and localfile dont streamout normally
            if(outp==1){ //VLC
                midbits = "dsph264enc ! rtph264pay ! udpsink";
                contextRun = "   Open n900videostrm.sdp file in VLC";
            } else if (outp==2){ //Xout
                midbits = "ffmpegcolorspace ! jpegenc "+Jquality+" ! tcpserversink";
                contextRun = "   from terminal, run: 'sh ~/Desktop/n900Xvideo.sh'";
            } else if (outp==3){//webcam
                //midbits = "ffmpegcolorspace ! smokeenc ! udpsink";  using jpeg for quality preferences.
                midbits = "ffmpegcolorspace ! jpegenc "+Jquality+" ! tcpserversink";
                contextRun = "   from terminal, run: 'sh ~/Desktop/n900Webvideo.sh'";
            } else if (outp==5){ //remote file
                midbits = "ffmpegcolorspace ! jpegenc "+Jquality+" ! tcpserversink";
                contextRun = "   from terminal, run: 'sh ~/Desktop/n900FileSave.sh'\n(Make sure that 'gstreamer0.10-ffmpeg' is installed on remote PC)";
            }
            streamout = "gst-launch-0.10 "+begbits+midbits+" host="+host+" port="+port;
            messager = "Run file on Remote PC: \n"+contextRun;
        }
    }
    else if (!video){
        streamout = "gst-launch-0.10 pulsesrc ! audioconvert ! volume volume="+ui->vol->text()+" ! audioresample ! nokiaaacenc ! rtpmp4apay ! udpsink host="+host+" port="+port;
        contextRun = "   Open n900audiostrm.sdp file in VLC";
        messager = "Run file on Remote PC: \n"+contextRun;

    }
    notify(messager, true);
    notify("streaming", false);
    ui->outWind->setText("...currently streaming...");
    QProcess*proc = new QProcess();
    proc->start(streamout);
    //ui->outWind->append(proc->readAll()); //NOW JUST NEED TO PASS OUTPUT FROM GST-LAUNCH BACK INTO OUTWIND
 }

void MainWindow::write2file(QString path, QString script){
    //writing bash script
    QFile file(path);
    file.open(QIODevice::ReadWrite | QIODevice::Text);
    QTextStream out(&file);
    out << script;
    file.close();
    //ui->outWind->append("Generated");

}

void MainWindow::executable(QString path){ //wish there was a way to preserve permissions over scp...
    QStringList args;
    args << "-c" << QString("echo %1chmod a+wrx "+path+"%1 | root").arg(QChar(0x22));
    QProcess* exer = new QProcess(this);
    exer->start("/bin/sh", args);
    exer->waitForFinished();
    exer->terminate();
}

void MainWindow::on_streambut_clicked()
{
    int cind = ui->vidsink->currentIndex();
    if(ui->filesinkname->text()=="" && (cind==4 || cind==5)){ //if filesink and blank
        notify("Fill out filename first", false);
    }
    else{
        if((cind==1) || ui->type1->currentIndex()==1){  //VLC (audio or Vid)
            ui->vidsink->setCurrentIndex(1); //set it to VLC (so http is never on)
            qDebug() << "is VLC";
            if(vlcsdpgenerated==ui->address1->text()+" "+ui->type1->currentText()){
                qDebug() << "and is also generated";
                helper();
            }
            else {
                vlcsdpgenerated = "";
                notify("Please generate a new SDP file", false);
            }
        }
        else if(cind!=0 && (!alreadygen.contains(ui->vidsink->currentText()+" "+ui->address1->text()+":"+ui->port1->text()))){   //if not http and the file hasnt been generated previously, then flag.
            sdpgenerated = false;
            if(cind!=4){ // and not filesink
                notify("Please generate and send a new file, then stream", false);
            }
            else { //local file streams
                helper();
            }
        }
        else if((cind==0) || (alreadygen.contains(ui->vidsink->currentText()+" "+ui->address1->text()+":"+ui->port1->text()))){
            helper();
        }
    }
}

void MainWindow::helper(){
    if(ui->type1->currentIndex()==0 && ui->camera1->currentIndex()==0){  //video and back
        cambackyes=true; //is it back camera, yes
        if(helpScreen){
            helpScreen=false;
            notify("Please Calibrate Back Camera",false);
            QString controls = "*Slide open camera lens-cap \n*Wait for Camera app to launch.\n*Soft press the camera button to focus until satisfied\n*Keeping the lens-cap open, close the Camera app\n*Once ready, press Stream button again";
            notify(controls,true);
        }
        else{
            streamProcess1();
        }
    }
    else {
        cambackyes=false;
        streamProcess1();
    }
}

void MainWindow::writeSettings(){
    QSettings settings("daUser", "tester");
    settings.beginGroup("MainWindow"); //beginWriteArray?
    settings.setValue("address",ui->address1->text());settings.setValue("port",ui->port1->text());
    settings.setValue("type",ui->type1->currentIndex()); settings.setValue("camera",ui->camera1->currentIndex()); settings.setValue("size",ui->size1->currentIndex());
    settings.setValue("custom",ui->custom1->text()); settings.setValue("user",ui->usernam->text());settings.setValue("volume", ui->vol->text()); settings.setValue("quality",ui->qcontrol->text());
    settings.setValue("checked",ui->rempass->checkState()); settings.setValue("OpenPath", openpath);

    if(ui->rempass->isChecked()){
        settings.setValue("password",ui->passwrd->text());
    } else{
        settings.setValue("password","");
    }
    settings.endGroup();
}

void MainWindow::applySettings(){
    QSettings settings("daUser", "tester");
    settings.beginGroup("MainWindow");
    if(openpath.length()<5){openpath="/home/user/MyDocs";}else{openpath=settings.value("Openpath").toString();}
    ui->address1->setText(settings.value("address").toString()); ui->port1->setText(settings.value("port").toString()); ui->type1->setCurrentIndex(settings.value("type").toInt());
    ui->size1->setCurrentIndex(settings.value("size").toInt());
    int camsrc = settings.value("camera").toInt(); if(camsrc==2){ui->camera1->setCurrentIndex(1);}else{ui->camera1->setCurrentIndex(camsrc);} //stops it from opening filedialog on entry.
    ui->custom1->setText(settings.value("custom").toString());ui->usernam->setText(settings.value("user").toString()); ui->passwrd->setText(settings.value("password").toString());
    volumeR = settings.value("volume").toString(); ui->vol->setText(volumeR); ui->qcontrol->setText(settings.value("quality").toString());
    if(ui->type1->currentIndex()==1){on_type1_activated(1);} else {on_type1_activated(0);}
    if(settings.value("checked")==(Qt::Checked)){ui->rempass->setCheckState(Qt::Checked);} else {ui->rempass->setCheckState(Qt::Unchecked);}
    settings.endGroup();
}

void MainWindow::streamProcess1(){
    //if(videoyes){
        hostname = ui->address1->text();
        portnum = ui->port1->text();
        //getting the size
        QString currentsize = ui->size1->currentText();
        if(currentsize == "Custom"){
            currentsize = ui->custom1->text();
        }
        //blanking out windows while streaming
        ui->stopsream->show(); ui->streambut->hide();
        showWin(false);
        //splitting the string
        QStringList sized = currentsize.split("x");
        widthnum = sized[0];
        heightnum = sized[1];
        int currOutput = ui->vidsink->currentIndex();
        //LED
        if(!fileyes)ledON(true);

        makeStream(hostname,cambackyes,videoyes,portnum,widthnum,heightnum, currOutput);
    /*}
    else if(!videoyes){*/

    //}
}

void MainWindow::showWin(bool hid){
    ui->address1->setProperty("enabled", hid);ui->port1->setProperty("enabled", hid); ui->type1->setProperty("enabled", hid); ui->size1->setProperty("enabled", hid);
    ui->camera1->setProperty("enabled", hid);ui->custom1->setProperty("enabled",hid);ui->outWind->setProperty("enabled", hid); ui->debuginfo->setProperty("enabled",hid);
    ui->sdpgen->setProperty("enabled", hid); ui->scpbutton->setProperty("enabled", hid);ui->vol->setProperty("enabled",hid);ui->vidsink->setProperty("enabled",hid);
    ui->tickqual->setProperty("enabled",hid);ui->qcontrol->setProperty("enabled",hid); ui->filesinkname->setProperty("enabled",hid);
}

void MainWindow::scpSender(QString user, QString pass, QString file){
    QString expectfile = QString("#!/usr/bin/expect -f\nset filename [lindex $argv 0]\nset user [lindex $argv 1]\nset pass [lindex $argv 2]\nset ipadd [lindex $argv 3]\nset timeout -1\nspawn scp $filename $user@$ipadd:/home/$user/Desktop\nexpect {\n%1yes/no)?%1 {exp_send %1yes%2r%1; exp_continue}\n%1*assword:%1 { send %1$pass%2r%1; exp_continue}\neof exit\n}").arg(QChar(0x22),QChar(0x5c));
    write2file("/home/user/.scp",expectfile);
    QProcess*sender1 = new QProcess();
    sender1->start("expect /home/user/.scp "+file+" "+user+" "+pass+" "+ui->address1->text());
    sender1->waitForFinished();
    QString output = sender1->readAll();
    ui->outWind->append(output);



    //This is the method of updating ssh known hosts, but it doesn't work, and also might update the wrong address at this position.
    //BAD METHOD. use method below this where it tells user what to delete.
    /*QStringList args1;
    args1 << "-c" << "sudo ssh-keygen -R "+ui->address1->text();
    QProcess*sshgen = new QProcess(this);
    sshgen->start("/bin/sh", args1);
    sshgen->waitForFinished();*/


    //1. First check if offending an existing key:
    //2. The check if right hostname
    //3. Then check if right machine "No route to host"
    //4. Then right password  "Permission denied, please try again"
    //5. Then if openssh installed "refused"
    //6. then correct

    if(output.contains("Offending")){
        QStringList oo = output.split("Offending");
        QString oo1 = oo[1];
        int obeg = oo1.indexOf(QChar(0x02f));       // "/"
        int oend = oo1.indexOf(QChar(0x03A));       // ":"
        QString kh = oo1.mid(obeg, (oend-obeg));    // gets /root/.ssh/known_hosts
        QString ln = oo1.mid(oend+1,1);             // gets line number
        notify("Remote Host Identification has changed",true);
        notify("Delete row "+ln+" from file "+kh,false);
        alreadygen.removeLast();
    }
    else if(output.contains("Invalid argument")){
        notify("Invalid argument.", true);
        notify("check your input.", false);
        ui->outWind->clear();
        alreadygen.removeLast();
    }


    else if(output.contains("resolve hostname")){
        notify("Invalid Hostname", true);
        notify("Verify Hostname of remote PC", false);
        alreadygen.removeLast();
    }

    else if(output.contains("No route")){
        notify("Invalid Address",true);
        notify("Verify IP of remote PC",false);
        alreadygen.removeLast();
    }
    else if(output.contains("denied")){
        notify("Wrong Username or Password",true);
        notify("Please check, and try again",false);
        alreadygen.removeLast();
    }
    else if(output.contains("refused")){
        notify("Connection Refused",true);
        notify("Please confirm that openssh-server is installed on remote system",false);
        alreadygen.removeLast();
    }
    else if(output.contains("100%")){
        ui->outWind->clear();
        ui->outWind->append("Sent....check your Remote PC Desktop\nYou may change Camera, Size, and Quality settings, otherwise hit Stream!");
        notify("File sent! Check your Desktop", true);

        //Delete generated file after sending. All files are also deleted on exit, but keep in case of app crash.
        QStringList arguments1;
        arguments1 << "-c" << "sudo rm -f "+currentFile;
        QProcess*process2 = new QProcess(this);
        process2->start("/bin/sh", arguments1);
        process2->waitForFinished();
        process2->terminate();

        notify("You may now stream", false);
        on_debuginfo_clicked(); //closes debug window

    }
    else {
        notify("Error: Timed out.",true);
        notify("Check the Address.", false);
        alreadygen.removeLast();
    }
    //showWin(true);
    sender1->terminate();
}

void MainWindow::notify(QString message, bool bottortop){  //for doing notifications to phone
    QProcess*warn1 = new QProcess();
    QString messy="";
    if(bottortop){         //message
        messy = QString("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:%1"+message+"%1 uint32:0 string:%1OK%1").arg(QChar(0x22));
    } else if (!bottortop){ //line
        messy = QString("dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:%1"+message+"%1").arg(QChar(0x22));
    }
    warn1->start(messy);
    warn1->waitForFinished();
    warn1->close();
    warn1->terminate();
}

void MainWindow::on_type1_activated(int index) //link on cmera1_activated into this? and then link size_activate into camera1_actiavet?!?!
{
    //Show Addres
    ui->labAddr->show(); ui->address1->show(); ui->labPort->show();; ui->port1->show();
    if(index==1){ //Audio
        ui->outWind->setText("Nothing to generate. Hit stream.");
        ui->labCam->hide();
        ui->labsize->hide();
        ui->camera1->hide();
        ui->size1->hide();
        ui->custom1->hide();
        ui->labcust->hide();
        ui->vidsink->hide();
        ui->labvidsink->hide();ui->labvol->setText("Vol(0-9):");
        ui->vol->setText(volumeR);
        ui->vol->show();
        ui->labvol->show();
        ui->tickqual->hide();
        ui->qcontrol->hide();
        ui->labfilenam->hide();
        ui->filesinkname->hide();

        vidoutput = "VLC sdp";
        videoyes = false;
    }
    else { //Video
        ui->labCam->show();
        ui->labsize->show();
        ui->camera1->show();
        ui->size1->show();
        ui->vidsink->show();
        ui->labvidsink->show();
        ui->vol->hide();
        ui->labvol->hide();
        ui->tickqual->show();
        on_tickqual_toggled(ui->tickqual->checkState());
        on_vidsink_activated(ui->vidsink->currentIndex());
        on_camera1_activated(ui->camera1->currentIndex()); ///CORRECT?
        on_size1_currentIndexChanged(ui->size1->currentText());
        videoyes = true;
    }
}

void MainWindow::on_camera1_activated(int index)
{
    if(index==1 || index==0){
        fileyes = false;
        ui->size1->show();
        ui->labsize->show();
        if(index==1){
            cambackyes = false;
            if(ui->size1->itemText(0)=="640x480"){
                ui->size1->removeItem(0);
            }
        }
        else if(index==0){
            cambackyes = true;
            if(ui->size1->itemText(0)!="640x480"){
                ui->size1->insertItem(0,"640x480");
            }
        }
    }
    else{ //File
        fileyes = true;
        ui->size1->hide();
        ui->labsize->hide();
        if(openpath=="."){openpath="/home/user/MyDocs";}
        QString pather = QFileDialog::getOpenFileName(this, tr("Open File for Streaming"),openpath, tr("Music (*.mp3 *.wav *.wma);;Video (*.avi *.mpg *.mp4 *.mpeg)"));
        QString dir = QFileInfo(pather).path();
        openpath = dir;
        openfile = QFileInfo(pather).absoluteFilePath();
        qDebug()<<openfile+" "+dir;
    }
}

void MainWindow::on_size1_currentIndexChanged(QString isCustom)
{
    if(isCustom=="Custom"){
        ui->labcust->show();
        ui->custom1->show();
    }
    else{
        ui->labcust->hide();
        ui->custom1->hide();
        ui->custom1->clear();
    }
}

void MainWindow::on_debuginfo_clicked()
{
    if(debugclicked){
        ui->outWind->hide();
        ui->sdpgen->hide();
        ui->scpbutton->hide();
        debugclicked=false;
    } else {
        ui->outWind->show();
        ui->sdpgen->show();
        on_vidsink_activated(ui->vidsink->currentIndex()); //to prevent
        debugclicked = true;
    }
}

QString MainWindow::getIP(){
    QStringList arguments1;
    arguments1 << "-c" << QString("echo %1ifconfig | grep 'inet addr:'| grep -v '127.0.0.1' | cut -d: -f2 | awk '{ print $1}'%1 | root").arg(QChar(0x22));
    QProcess*process1 = new QProcess(this);
    process1->start("/bin/sh", arguments1);
    process1->waitForFinished();
    QString tmp = process1->readAll();
    tmp = tmp.split(QRegExp("\\s+")).at(0); //removes spaces at end
    qDebug() << tmp;
    return tmp;

}

void MainWindow::on_sdpgen_clicked()
{
    //sdpyes = false;
    QString localip=getIP();
    ui->outWind->setText("Local IP is "+localip);
    QString decoder;QString typer;
    int outpp = ui->vidsink->currentIndex();

    if(outpp==0){ //Http   <------Needs hiding
        notify("Don't need to generate anything for this", false); //Need to get rid of....
        ui->outWind->clear();
    }
    else if(outpp==1){ //VLC old
        if(videoyes){ typer = "video"; decoder ="H264/90000";}
        else if(!videoyes){ typer="audio"; decoder="MP4A-LATM/48000/2";}
        currentFile ="/home/user/MyDocs/n900"+typer+"strm.sdp";
        write2file(currentFile,"v=0\nm="+typer+" "+ui->port1->text()+" RTP/AVP 96\nc=IN IP4 "+localip+"\na=rtpmap:96 "+decoder); //VLC
        ui->outWind->append("Generated file at: "+currentFile);
        vlcsdpgenerated = ui->address1->text()+" "+ui->type1->currentText(); //generated, but doesnt need to be sent via scp (for windows) (it's checked against current ip @stream to see if it needs to be regenerated)
    }

    else if(outpp==2) { //Xout
        currentFile = "/home/user/MyDocs/n900Xvideo.sh";
        write2file(currentFile,"gst-launch-0.10 tcpclientsrc host="+localip+" port="+ui->port1->text()+"  ! jpegdec ! autovideosink"); //Xout
        ui->outWind->append("Generated file at: "+currentFile);
    }
    else if(outpp==3) { //webcam
        currentFile = "/home/user/MyDocs/n900Webvideo.sh";
        //write2file(currentFile,"gst-launch-0.10 udpsrc port="+ui->port1->text()+" ! smokedec ! ffmpegcolorspace ! v4l2loopback device=/dev/video0");  //webcam
        //Using Jpeg for now, higer quality?
        write2file(currentFile,"gst-launch-0.10 tcpclientsrc host="+localip+" port="+ui->port1->text()+"  ! jpegdec ! ffmpegcolorspace ! v4l2loopback device=/dev/video0"); //Xout
        notify("Please make sure that v42l2loopback module is installed on your PC", true);
        ui->outWind->append("Generated file at: "+currentFile);

    }
    else if(outpp==4) {//filesink --generate button hidden for this, but just in case.
        notify("Don't need to generate anything for local file", false);
        ui->outWind->clear();

    }
    else if(outpp==5){//remote filesink
        currentFile = "/home/user/MyDocs/n900FileSave.sh";
        write2file(currentFile,"gst-launch-0.10 tcpclientsrc host="+localip+" port="+ui->port1->text()+" ! jpegdec ! ffenc_mpeg2video ! filesink location=/home/"+ui->usernam->text()+"/Desktop/"+ui->filesinkname->text()+".mpg");
        ui->outWind->append("Generated file at: "+currentFile);

    }
    //alreadygen.append(outpp) //old integer method
    notify("Generated",false);
    ui->scpbutton->show();
}

void MainWindow::ledON(bool led){
    QString lstream = "";
    QProcess*ledterm = new QProcess();
    if(led){ //ON
        lstream = QString("dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_activate string:%1PatternWebcamActive%1").arg(QChar(0x22));
        ledterm->start(lstream);
        ledterm->waitForFinished();
    }
    else if (!led){ //OFF
        lstream = QString("dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:%1PatternWebcamActive%1").arg(QChar(0x22));
        ledterm->start(lstream);
        ledterm->waitForFinished();
        ledterm->terminate();
    }
}

void MainWindow::on_stopsream_clicked()
{
    QProcess*terminator1 = new QProcess();
    terminator1->start("killall gst-launch-0.10 socat");
    terminator1->waitForFinished();
    terminator1->terminate();

    //Turn off LED
    ledON(false);
    //
    ui->outWind->clear();
    ui->outWind->append("Stopped Streaming");
    ui->stopsream->hide();
    ui->streambut->show();
    //making everything visible
    showWin(true);
    //
    proc.terminate();//doesn't do anything really
}

void MainWindow::closeEvent(QCloseEvent *event)
{
   event->ignore();

   //Deletes all generated files
   QStringList arguments1;
   arguments1 << "-c" << "sudo rm -f /home/user/MyDocs/n900videostrm.sdp /home/user/MyDocs/n900audiostrm.sdp /home/user/MyDocs/n900Xvideo.sh /home/user/MyDocs/n900Webvideo.sh /home/user/MyDocs/n900FileSave.sh /home/user/.scp /home/user/.httpstream";
   QProcess*process2 = new QProcess(this);
   process2->start("/bin/sh", arguments1);
   process2->waitForFinished();
   process2->terminate();

   on_stopsream_clicked();  //closes all stream
   writeSettings();
   event->accept();
}

void MainWindow::on_scpbutton_clicked()
{
  ui->outWind->setText("This will only work if your username is the same on the PC: e.g <user>@+"+ui->address1->text()+":~/Desktop");
  ui->scpframe->show();
}

void MainWindow::on_scpsend_clicked()
{
    alreadygen.append(ui->vidsink->currentText()+" "+ui->address1->text()+":"+ui->port1->text()); //adds generated selection to list.
    ui->scpsend->setStyleSheet("QPushButton {background-color : rgb(60, 60, 100); color : white;}");
    ui->scpframe->hide();
    //showWin(false);
    notify("sending....please wait",false);
    scpSender(ui->usernam->text(),ui->passwrd->text(),currentFile);
    ui->scpsend->setStyleSheet("QPushButton {background-color : white; color : black;}");    
}

void MainWindow::on_vidsink_activated(int index)  //First part is for showing the filename widgets
{
    if(ui->camera1->itemText(2)!="File (experimental)"){
        ui->camera1->addItem("File (experimental)");
    }
    if(ui->type1->currentIndex()!=1){
        if(index==4 || index==5){//File
            ui->labfilenam->show();
            ui->filesinkname->show();
            ui->tickqual->show();
            if(index==4){ //local
                ui->sdpgen->hide();
                ui->scpbutton->hide();
                ui->labfilenam->setText("     Filename (/home/user/MyDocs/.videos/):");
                //Hide top row
                ui->address1->hide(); ui->labAddr->hide(); ui->port1->hide(); ui->labPort->hide();
                ui->outWind->setText("Nothing needed to generate or send. \nPlease fill out name of video and hit Stream.");
                sdpgenerated = true; //doesnt need to generate one.
                ui->camera1->removeItem(2); //<=========== Doesn't use file as source.////////
                ui->labsize->show(); ui->size1->show();
            }
            if(index==5) {
                if(debugclicked){ui->sdpgen->show();}  //error when switching from local file to remote file.
                ui->labfilenam->setText("    Remote Filename:");
                vidoutput="RemoteFilescript";
                ui->address1->show(); ui->labAddr->show(); ui->port1->show(); ui->labPort->show();
                ui->outWind->setText("Fill out filename and then generate");
            }
        } else if(index!=4 || index!=5){
            ui->address1->show(); ui->labAddr->show(); ui->port1->show(); ui->labPort->show();
            ui->labfilenam->hide();
            ui->filesinkname->hide();
            if(debugclicked){ui->sdpgen->show();}// stops it appearing when showdebug hasnt been clicked yet
            if(index==0){
                ui->sdpgen->hide();
                ui->scpbutton->hide();
                ui->outWind->setText("Nothing needed to generate or send. \nPlease hit Stream.");
                sdpgenerated = true; //doesnt need to generate one.
            } else {
                ui->outWind->setText("Please generate and send");
                ui->tickqual->show();
                if(index==1){vidoutput = "VLC sdp";}
                if(index==2){vidoutput = "Xscript";}
                if(index==3){vidoutput="Webscript";}
            }
        }
    }
    else if(ui->type1->currentIndex()==1){ //audio
        vidoutput = "VLC sdp";
    }
    ui->sdpgen->setText("Generate "+vidoutput+" file");
    ui->scpbutton->setText("Send "+vidoutput+" to Linux PC");
}
/*
Add microphone support for use as main remote desktop mic.??
Fix script for front camera + LED shutdown on some devices. ??
Fix IP address issues
Add zooming feature
Ncurses version
Stream to the web as http --using damion's scripts.
Add dialog to check whether lens cap still open when exiting.
Catch error of no filename for File and remotefile before sending.
Perhaps use sdpyes to check whether file has already been generated, and throw error if address has been changed or something.
For offending key error in expect, maybe just peform 'ssh-keygen -R hostaddress' to bypass this, rather than let user do this themselves.
*/

void MainWindow::on_tickqual_toggled(bool checked)
{
    if(checked==true){
        ui->labvol->hide();
        ui->qcontrol->show();
    }
    else if(checked==false) {
        ui->qcontrol->hide();
    }
}
/*Added notifications.
Removed sdpyes (which did nothing) ----marybe it did!
You have some global strings widthnum, which aren't used anywhere else. hostname should be used more than once(though updated at generating stage).
Delete generated files from device upon sending.
Added quality control to VLC

*/
