#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QProcess>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

protected:
void closeEvent(QCloseEvent *event);

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    bool helpScreen;
    QString hostname;
    QString portnum;
    QString widthnum;
    QString heightnum;
    bool cambackyes;
    bool videoyes;
    QString currentFile;
    bool sdpgenerated;
    QString vidoutput;
    QProcess proc;
    QString volumeR;
    bool debugclicked;
    QStringList alreadygen; //vidsink and address:port combo. -- implement later.

private slots:
    void on_tickqual_toggled(bool checked);
    void on_vidsink_activated(int index);
    void writeSettings(); void applySettings();
    void scpSender(QString user, QString pass, QString file);
    void on_scpsend_clicked();
    void on_scpbutton_clicked();
    void streamProcess1();
    void on_stopsream_clicked();
    QString getIP();
    void on_sdpgen_clicked();
    void on_debuginfo_clicked();
    void on_size1_currentIndexChanged(QString isCustom);
    void on_camera1_activated(int index);
    void on_type1_activated(int index);
    void on_streambut_clicked();
    void makeStream(QString host, bool backcamera, bool video, QString port, QString width, QString height, int output);
    void write2file(QString path, QString script);
    void notify(QString message, bool messageorline);
    void ledON(bool yepper);
    void showWin(bool hid);
};

#endif // MAINWINDOW_H
