import QtQuick 1.0
import "sizer.js" as Sizer;

Rectangle {
    id:globalhiscorepanel
    height: board.height - 80
    width:  board.width/1.5
    y: 50
    state: "HIDDEN"
    border.color: "#00ff00"
    border.width: 5
    color:  "black"

    states: [
        State {
            name: "HIDDEN"
            PropertyChanges { target: globalhiscorepanel; x: board.width + 2}
        },
        State {
            name: "VISIBLE"
            PropertyChanges { target: globalhiscorepanel; x: board.width - width}
        }
    ]

    transitions: Transition {
        NumberAnimation { properties: "x"; easing.type: Easing.InOutQuad }
    }

    //Dummy mouse area to stop events being passed through
    MouseArea {
        anchors.fill: parent
    }

    Text {
        id: globalhiscoreheader
        text: "Global Hi Scores"
        font.pixelSize: Sizer.largeFontSize()
        anchors.horizontalCenter: globalhiscorepanel.horizontalCenter
        anchors.top: globalhiscorepanel.top
        anchors.topMargin: 5
        color:  "#00ff00"
    }

    Text { text: "Pos"
        id:poslabel
        color:"#00ff00"
        font.pixelSize: Sizer.largeFontSize()
        width: (globalhiscorepanel.width-10)/8
        anchors.top: globalhiscoreheader.bottom
        anchors.topMargin: 5
        anchors.left: parent.left
        anchors.leftMargin: 5
    }
    Text { text: "Gamer"
        id:gamerlabel
        color:"#00ff00"
        font.pixelSize: Sizer.largeFontSize()
        width: (globalhiscorepanel.width-10)/4
        anchors.top: globalhiscoreheader.bottom
        anchors.topMargin: 5
        anchors.left: poslabel.right
        anchors.leftMargin: 0
    }
    Text { text: "Score"
        id:scorelabel
        color:"#00ff00"
        font.pixelSize: Sizer.largeFontSize()
        width: (globalhiscorepanel.width-10)/4
        anchors.top: globalhiscoreheader.bottom
        anchors.topMargin: 5
        anchors.left: gamerlabel.right
        anchors.leftMargin: 0
    }
    Text { text: "Lvl"
        id:levellabel
        color:"#00ff00"
        font.pixelSize: Sizer.largeFontSize()
        width: (globalhiscorepanel.width-10)/8
        anchors.top: globalhiscoreheader.bottom
        anchors.topMargin: 5
        anchors.left: scorelabel.right
        anchors.leftMargin: 0
    }
    Text { text: "Date"
        id:datelabel
        color:"#00ff00"
        font.pixelSize: Sizer.largeFontSize()
        width: (globalhiscorepanel.width-10)/4
        anchors.top: globalhiscoreheader.bottom
        anchors.topMargin: 5
        anchors.left: levellabel.right
        anchors.leftMargin: 0
    }

    Component {
             id: scoreDelegate
             Row {
                 spacing: 0
                 Text { text: position
                     color:"#00ff00"
                     font.pixelSize: Sizer.largeFontSize()
                     width: (globalhiscorepanel.width-10)/8
                 }
                 Text { text: gamer
                     color:"#00ff00"
                     font.pixelSize: Sizer.largeFontSize()
                     width: (globalhiscorepanel.width-10)/4
                 }
                 Text { text: score
                     color:"#00ff00"
                     font.pixelSize: Sizer.largeFontSize()
                     width: (globalhiscorepanel.width-10)/4
                 }
                 Text { text: level
                     color:"#00ff00"
                     font.pixelSize: Sizer.largeFontSize()
                     width: (globalhiscorepanel.width-10)/8
                 }
                 Text { text: date
                     color:"#00ff00"
                     font.pixelSize: Sizer.largeFontSize()
                     width: (globalhiscorepanel.width-10)/4
                 }
             }
         }

         ListView {
             anchors.left: parent.left
             anchors.rightMargin: 5
             anchors.leftMargin: 5
             anchors.right:  parent.right
             anchors.bottom: textviewscores.top
             anchors.bottomMargin: 5
             anchors.topMargin: 5

             anchors.top: poslabel.bottom

             clip: true

             model: GlobalHiScores
             delegate: scoreDelegate
         }

         Text {
             id: textviewscores
             color: "#00ff00"
             text: "View More Scores"
             anchors.bottom: parent.bottom
             anchors.right: parent.right
             font.pixelSize: 20
             MouseArea {
                 anchors.fill: parent;
                 onClicked: Qt.openUrlExternally("http://www.piggz.co.uk?page=spaceinvaders-scores");
             }
         }


}
