#include "LatitudeMap.h"
#include <QtWebKit/QWebView>
#include <QVBoxLayout>
#include <QtWebKit/QWebFrame>
#include <QDebug>
#include <QTimer>
#include <QLabel>
#include <qjson/parser.h>

#include "LatitudeSettings.h"

#ifndef Q_WS_MAEMO_5
#include <QPushButton>
#endif
LatitudeMap::LatitudeMap(QWidget *parent) :
    QWidget(parent)
{
    connect(&latitude, SIGNAL(gotPosition(QtMobility::QGeoPositionInfo)), this, SLOT(setPosition(QtMobility::QGeoPositionInfo)));

    m_settingsDialog = new LatitudeSettings(this);
    connect(m_settingsDialog, SIGNAL(authorize()), &latitude, SLOT(requestToken()));
    connect(m_settingsDialog, SIGNAL(accepted()), this, SLOT(settingsDone()));

    m_layout = new QVBoxLayout();

    m_address = new QLabel("Waiting for location", this);
    m_layout->addWidget(m_address);
    setLayout(m_layout);
    m_networkManager = new QNetworkAccessManager(this);
    connect(m_networkManager, SIGNAL(finished(QNetworkReply*)),this, SLOT(replyFinished(QNetworkReply*)));

#ifndef Q_WS_MAEMO_5
    m_settingsButton = new QPushButton(tr("Settings"), this);
    m_layout->addWidget(m_settingsButton);
    connect(m_settingsButton, SIGNAL(clicked()), this, SLOT(showSettings()));

    QTimer::singleShot(5000, this, SLOT(test()));

    QTimer *timer = new QTimer(this);
        connect(timer, SIGNAL(timeout()), this, SLOT(test()));
        timer->start(100);
#endif    
}

void LatitudeMap::test()
{
    //=====================
    QtMobility::QGeoPositionInfo pos;
    QtMobility::QGeoCoordinate coord;
    coord.setLongitude(-3.14);
    coord.setLatitude(54.81);
    coord.setAltitude(5);
    pos.setCoordinate(coord);
    pos.setAttribute(QtMobility::QGeoPositionInfo::HorizontalAccuracy, 1);
    setPosition(pos);
}

void LatitudeMap::setPosition(const QtMobility::QGeoPositionInfo &pos)
{
    qDebug() << "setPosition "<< pos.coordinate();
    float lat, lon;
    lat = pos.coordinate().latitude();
    lon = pos.coordinate().longitude();

    //Get the address of the location
    QUrl url("http://where.yahooapis.com/geocode");
    url.addQueryItem("q", QString("%1,+%2").arg(lat).arg(lon));
    url.addQueryItem("gflags", "R");
    url.addQueryItem("flags", "J");
    url.addQueryItem("appid", "KTtnXN5e");

    QNetworkRequest request(url);

    m_networkManager->get(request);
}

void LatitudeMap::showSettings()
{
    m_settingsDialog->show();

    m_settingsDialog->setUpdateIterval(oauthSettings.value("update_interval", 5).toInt());
    m_settingsDialog->setPositioningMethod((QGeoPositionInfoSource::PositioningMethod)(oauthSettings.value("positioning_method", QGeoPositionInfoSource::AllPositioningMethods).toInt()));
}

void LatitudeMap::settingsDone()
{
    qDebug() << "Settings Done";
    latitude.setUpdateInterval(m_settingsDialog->updateInterval());
    latitude.setPositioningMethod(m_settingsDialog->positioningMethod());
}

void LatitudeMap::replyFinished(QNetworkReply *reply)
{
    QByteArray data = reply->readAll();
    QJson::Parser parser;
    bool ok;
    QVariantMap result;

    result = parser.parse(data, &ok).toMap();

    QVariantMap resultset = result["ResultSet"].toMap();
    QVariantList results = resultset["Results"].toList();
    QVariantMap first = results[0].toMap();
    QString address = first["neighborhood"].toString() + ", " + first["city"].toString() + ", " + first["county"].toString()  + ", " + first["uzip"].toString();

    m_address->setText(address);
}
