#ifndef TRAILGPXVIEW_H
#define TRAILGPXVIEW_H

#include <QWidget>
#include <QtLocation/QGeoPositionInfo>
#include "Latitude.h"

class QWebView;
class QVBoxLayout;
class LatitudeSettings;

#ifndef Q_WS_MAEMO_5
    class QPushButton;
#endif

class LatitudeMap : public QWidget
{
    Q_OBJECT
public:
    explicit LatitudeMap(QWidget *parent = 0);

public slots:
    void setPosition(const QtMobility::QGeoPositionInfo &pos);
    void settingsDone();
    void test();

signals:

public slots:

    void showSettings();

private:
    QWebView *m_webView;
    QVBoxLayout *m_layout;

    QString m_html;

    Latitude latitude;
    LatitudeSettings *m_settingsDialog;

#ifndef Q_WS_MAEMO_5
    QPushButton *m_settingsButton;
#endif
};

#endif // TRAILGPXVIEW_H
