import QtQuick 1.0
import Qt 4.7

import "sizer.js" as Sizer;

Rectangle {
    id: mainBoard
    color: "#000000"
    width: 640
    height:  360

    //Intro Panel
    Intro {
        id: introWindow
        anchors.fill: parent
    }

    //Start Panel
    Start {
        id:startWindow
        anchors.fill: parent
        visible: false
        opacity: 0
    }

    LevelSelector {
        id:levelSelector
        anchors.fill: parent
        visible: false
        opacity: 0
    }

    //Game Board
    Board {
        id: gameBoard
        anchors.fill: parent
        visible: false
        opacity: 0
    }

    //Hide intro window timer
    Timer {
        repeat: false
        interval: 3000
        running: true

        onTriggered: {
            animateIntroToStart.start();
            startWindow.show();
        }
    }

    //Transition Effects
    //Intro to Start
    ParallelAnimation {
        id:animateIntroToStart

        SequentialAnimation {
            id: animIntroHide
            NumberAnimation { target: introWindow; property: "opacity"; easing.type: Easing.Linear; to: 0; duration: 600 }
            PropertyAnimation { target: introWindow; property: "visible"; to: false }
        }

        SequentialAnimation {
            id:animStartShow
            PropertyAnimation { target: startWindow; property: "visible"; to: true }
            NumberAnimation {  target: startWindow; property: "opacity"; easing.type: Easing.Linear; to: 1; duration: 1500 }
        }
    }

    //Start to Intro
    ParallelAnimation {
        id:animateStartToIntro
        SequentialAnimation {
            NumberAnimation { target: startWindow; property: "opacity"; easing.type: Easing.Linear; to: 0; duration: 1000 }
            PropertyAnimation { target: startWindow; property: "visible"; to: false }
        }

        SequentialAnimation {
            PropertyAnimation { target: introWindow; property: "visible"; to: true }
            NumberAnimation {  target: introWindow; property: "opacity"; easing.type: Easing.Linear; to: 1; duration: 1000 }
        }
    }

    //Start to Level Select
    ParallelAnimation {
        id:animateStartToLevelSelect
        SequentialAnimation {
            NumberAnimation { target: startWindow; property: "opacity"; easing.type: Easing.Linear; to: 0; duration: 1000 }
            PropertyAnimation { target: startWindow; property: "visible"; to: false }
        }

        SequentialAnimation {
            PropertyAnimation { target: levelSelector; property: "visible"; to: true }
            NumberAnimation {  target: levelSelector; property: "opacity"; easing.type: Easing.Linear; to: 1; duration: 1000 }
        }
    }

    //Level Selector to Game
    ParallelAnimation {
        id:animateLevelSelectorToGame
        SequentialAnimation {
            NumberAnimation { target: levelSelector; property: "opacity"; easing.type: Easing.Linear; to: 0; duration: 1000 }
            PropertyAnimation { target: levelSelector; property: "visible"; to: false }
        }

        SequentialAnimation {
            PropertyAnimation { target: gameBoard; property: "visible"; to: true }
            NumberAnimation {  target: gameBoard; property: "opacity"; easing.type: Easing.Linear; to: 1; duration: 1000 }
        }
    }

    //Game to Start
    ParallelAnimation {
        id:animateGameToStart
        SequentialAnimation {
            NumberAnimation { target: gameBoard; property: "opacity"; easing.type: Easing.Linear; to: 0; duration: 1000 }
            PropertyAnimation { target: gameBoard; property: "visible"; to: false }
        }

        SequentialAnimation {
            PropertyAnimation { target: startWindow; property: "visible"; to: true }
            NumberAnimation {  target: startWindow; property: "opacity"; easing.type: Easing.Linear; to: 1; duration: 1000 }
        }
    }

//===================Functions================================

    Component.onCompleted: {
        startWindow.startClicked.connect(showLevelSelector)
        startWindow.exitClicked.connect(quitGame)
        gameBoard.exitClicked.connect(endGame)

        levelSelector.playGame.connect(playGame)
    }

    function showLevelSelector(){
        animateStartToLevelSelect.start();
    }

    function playGame(levelPack, backgroundImage, levels) {
        console.log(levelPack);
        gameBoard.backgroundImage = "levels/" + levelPack + "/" + backgroundImage;
        selectedLevelPack = levelPack;
        animateLevelSelectorToGame.start();
        gameBoard.numLevels = levels;
        gameBoard.focus = true;
    }

    function quitGame() {
        saveSettings();
        Qt.quit();
    }

    function endGame() {
        gameBoard.endGame();
        animateGameToStart.start();
    }

    /*
    Connections {
        target: HiScores
        onMessageReceived: {
            displayMessage(HiScores.lastMessage());
            messagetimer.start();
        }
    }
    */

    property string gameState
    property string lastGameState

    property string selectedLevelPack

    //Settings============================================

    property string useAccelerometer
    property string sFX
    property string gamerName
    property string password

    property int keyLeft
    property int keyRight
    property int keyFire

    function nowString()
    {
        var d = new Date();
        var curr_date = d.getDate();
        var curr_month = d.getMonth() + 1;
        var curr_year = d.getFullYear();
        return curr_year + "-" + curr_month + "-" + curr_date;
    }

    function loadSettings(){
        useAccelerometer = Helper.getSetting("UseAccelerometer", "TRUE");
        sFX = Helper.getSetting("SFX", "TRUE");
        gamerName = Helper.getSetting("GamerName", "");
        password = Helper.getSetting("Password", "");
        keyLeft = Helper.getSetting("KeyLeft", Qt.Key_Left);
        keyRight = Helper.getSetting("KeyRight", Qt.Key_Right);
        keyFire = Helper.getSetting("KeyFire", Qt.Key_Space);
    }

    function saveSettings() {
        Helper.setSetting("UseAccelerometer", useAccelerometer);
        Helper.setSetting("SFX", sFX);
        Helper.setSetting("GamerName", gamerName);
        Helper.setSetting("Password", password);
        Helper.setSetting("KeyLeft", keyLeft);
        Helper.setSetting("KeyRight", keyRight);
        Helper.setSetting("KeyFire", keyFire);
    }
}


