import QtQuick 1.0

Rectangle {
    id: startWindow
    width: 640
    height: 360
    visible: false
    opacity: 0

    signal startClicked
    signal exitClicked

    Image {
        id: background
        source: "pics/intro.svg"
        smooth: true
        z: 0
        fillMode: Image.Stretch
        anchors.fill: parent
    }

    function show() {
        starttimer1.start();
        starttimer2.start();
        starttimer3.start();
    }

    Timer {
        id: starttimer1
        repeat:  false
        interval: 1000
        running: false
        onTriggered: {
            farmlogo.state = "VISIBLE";
        }
    }

    Timer {
        id: starttimer2
        repeat:  false
        interval: 2000
        running: false
        onTriggered: {
            breakoutlogo.state = "VISIBLE";
        }
    }

    Timer {
        id: starttimer3
        repeat:  false
        interval: 3000
        running: false
        onTriggered: {
            animButtonShow.start();
        }
    }

    Image {
        id: closebutton

        source: "pics/x.svg"
        width: 48
        height: 48
        anchors.right: parent.right
        anchors.rightMargin: 0
        anchors.top: parent.top
        anchors.topMargin: 0
        fillMode: Image.PreserveAspectFit
        smooth: true

        MouseArea {
               id: closearea
               anchors.fill: parent      
           }
       }

    Item {
        id: farmlogo
        width: 300
        height: 100
        state: "HIDDEN"

        anchors.verticalCenter: startWindow.verticalCenter
        anchors.verticalCenterOffset: -100
        anchors.horizontalCenter: startWindow.horizontalCenter
        anchors.horizontalCenterOffset: -150


        Image {
            id: farmimage

            source: "pics/farm.png"
            width: parent.width
            height: parent.height
            smooth:  true
        }

        states: [
            State {
                name: "HIDDEN"
                PropertyChanges { target: farmlogo; width: 0}
                PropertyChanges { target: farmlogo; height: 0}
            },
            State {
                name: "VISIBLE"
                PropertyChanges { target: farmlogo; width: 300}
                PropertyChanges { target: farmlogo; height: 100}
            }
        ]

        transitions: Transition {
            NumberAnimation { properties: "width"; easing.type: Easing.OutBounce; duration: 1000 }
            NumberAnimation { properties: "height"; easing.type: Easing.OutBounce; duration: 1000 }
        }
    }

    Item {
        id: breakoutlogo
        width: 300
        height: 100
        state: "HIDDEN"

        anchors.verticalCenter: startWindow.verticalCenter
        anchors.verticalCenterOffset: 0
        anchors.horizontalCenter: startWindow.horizontalCenter
        anchors.horizontalCenterOffset: 50


        Image {
            id: breakoutimage

            source: "pics/breakout.png"
            width: parent.width
            height: parent.height
            smooth:  true
        }

        states: [
            State {
                name: "HIDDEN"
                PropertyChanges { target: breakoutlogo; width: 0}
                PropertyChanges { target: breakoutlogo; height: 0}
            },
            State {
                name: "VISIBLE"
                PropertyChanges { target: breakoutlogo; width: 500}
                PropertyChanges { target: breakoutlogo; height: 100}
            }
        ]

        transitions: Transition {
            NumberAnimation { properties: "width"; easing.type: Easing.OutBounce; duration: 1000 }
            NumberAnimation { properties: "height"; easing.type: Easing.OutBounce; duration: 1000 }
        }
    }


    //Start button
    Item {
        id: buttonStart
        width: 100
        height: 100
        opacity: 0

        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.bottomMargin: 50
        anchors.leftMargin: 50

        Image {
            anchors.fill: parent
            source: "pics/start.png"
        }

        MouseArea {
            id: buttonStartArea
            anchors.fill: parent

            onClicked: {

            }
        }
    }

    //Options button
    Item {
        id: buttonOptions
        width: 64
        height: 64
        opacity: 0

        anchors.bottom: buttonStart.bottom
        anchors.left: buttonStart.right
        anchors.leftMargin: 40

        Image {
            anchors.fill: parent
            source: "pics/options.png"
        }

        MouseArea {
            id: buttonOptionsArea
            anchors.fill: parent

            onClicked: {

            }
        }
    }

    //Options button
    Item {
        id: buttonHiScore
        width: 64
        height: 64
        opacity: 0

        anchors.bottom: buttonStart.bottom
        anchors.left: buttonOptions.right
        anchors.leftMargin: 40

        Image {
            anchors.fill: parent
            source: "pics/hiscore.png"
        }

        MouseArea {
            id: buttonHiScoreArea
            anchors.fill: parent
        }
    }

    //Options button
    Item {
        id: buttonGlobal
        width: 64
        height: 64
        opacity: 0

        anchors.bottom: buttonStart.bottom
        anchors.left: buttonHiScore.right
        anchors.leftMargin: 40

        Image {
            anchors.fill: parent
            source: "pics/globalscore.png"
        }

        MouseArea {
            id: buttonGlobalArea
            anchors.fill: parent

            onClicked: {

            }
        }
    }



    //Show the buttons in sequence
    SequentialAnimation {
        id: animButtonShow
        NumberAnimation { target: buttonStart; property: "opacity"; easing.type: Easing.Linear; to: 1; duration: 500 }
        NumberAnimation { target: buttonOptions; property: "opacity"; easing.type: Easing.Linear; to: 1; duration: 500 }
        NumberAnimation { target: buttonHiScore; property: "opacity"; easing.type: Easing.Linear; to: 1; duration: 500 }
        NumberAnimation { target: buttonGlobal; property: "opacity"; easing.type: Easing.Linear; to: 1; duration: 500 }

    }

    Component.onCompleted: {
        buttonStartArea.clicked.connect(startClicked)
        closearea.clicked.connect(exitClicked)
    }


    /*
    Menu {
        id:menupanel
        anchors.right: menubutton.left
        state: "HIDDEN";
        z:15
    }
*/

/*
    Settingswindow {
        id:settingspanel;
        z: 10
    }

    Hiscorewindow {
        id:hiscorepanel;
        z: 9
    }

    GlobalHiScores {
        id:globalhiscorepanel
        z: 8
    }
*/

}
