import QtQuick 1.0

Rectangle {
    id: introWindow
    width: 640
    height: 630
    color: "#000000"

    Image {
        id: imgStudio
        source: "pics/pgz-studio.svg"
        state: "HIDDEN"
        anchors.centerIn: parent

        states: [
            State {
                name: "HIDDEN"
                PropertyChanges { target: imgStudio; opacity: 0}
            },
            State {
                name: "VISIBLE"
                PropertyChanges { target: imgStudio; opacity: 1}
            }
        ]

        transitions: Transition {
            NumberAnimation { target: imgStudio; properties: "opacity"; easing.type: Easing.Linear; duration: 1000 }
        }
    }

    Timer {
        repeat: false
        interval: 1000
        running:  true

        onTriggered: {
            imgStudio.state = "VISIBLE"
        }
    }
}
