import QtQuick 1.0

Item {
    id:block
    property int strength: 1
    property string type: "none"

    Image {
        id: blockimg;
        anchors.fill: parent
        smooth: true
    }

    function init()
    {
        if (strength == 0) {
            block.visible = false;
            type = "none";
        } else {
            block.visible = true;
            if (strength == 3) {
                type = "brick";
            } else if (strength == 2) {
                type = "wood";
            } else if (strength == 1 ) {
                type = "bale";
            }

            blockimg.source = "levels/" + mainBoard.selectedLevelPack + "/" + type + "-" + strength + ".svg";
        }
    }

    function hit()
    {
        if (strength > 0) {
            strength--;
        }

        if (strength == 0) {
            blowUp();
        } else {
            blockimg.source = "levels/" + mainBoard.selectedLevelPack + "/" + type + "-" + strength + ".svg";
        }
    }

    function blowUp()
    {
        state = 0;
        animBlockHide.start();
    }

    SequentialAnimation {
        id: animBlockHide
        NumberAnimation { target: block; property: "opacity"; easing.type: Easing.Linear; to: 0; duration: 200 }
        PropertyAnimation { target: block; property: "visible"; to: false }
    }

}
