#ifndef LEVELPACKMODEL_H
#define LEVELPACKMODEL_H

#include <QAbstractListModel>
#include <QString>
#include <QDir>
#include <QList>

#include "LevelPack.h"

class LevelPackModel : public QAbstractListModel
{
    Q_OBJECT
public:
    enum LevelPackRoles {
        IDRole = Qt::UserRole + 1,
        NameRole,
        DescriptionRole,
        NumLevelsRole,
        BackgroundImageRole
    };

    explicit LevelPackModel(const QString &baseDir, QObject *parent = 0);

    virtual int rowCount(const QModelIndex &parent) const;
    virtual QVariant data(const QModelIndex &index, int role = Qt::DisplayRole ) const;

signals:


public slots:

private:
    QString m_baseDirPath;
    QDir m_baseDir;

    QList<LevelPack*> m_levels;

};

#endif // LEVELPACKMODEL_H
