#include "LevelPackModel.h"
#include <QDebug>

LevelPackModel::LevelPackModel(const QString &baseDir, QObject *parent) :
    QAbstractListModel(parent)
{

    QHash<int, QByteArray> roles;
    roles[IDRole] = "levelid";
    roles[NameRole] = "name";
    roles[DescriptionRole] = "description";
    roles[NumLevelsRole] = "numlevels";
    roles[BackgroundImageRole] = "backgroundimage";
    setRoleNames(roles);

    m_baseDirPath = baseDir;
    m_baseDir.setPath(m_baseDirPath);

    //Loop over each dir in the base dir
    QFileInfoList dirList = m_baseDir.entryInfoList(QDir::Dirs | QDir::NoDotAndDotDot | QDir::NoSymLinks);
    for(int i = 0; i < dirList.count(); ++i) {
        QDir levelDir(dirList[i].filePath());

        qDebug() << levelDir.path();

        if (levelDir.exists("pgz-fb-levelpack.dat")) {
            LevelPack* level = new LevelPack(levelDir.filePath("pgz-fb-levelpack.dat"));
            if (level->valid()) {
                m_levels << level;
            } else {
                qDebug() << "level pack is not valid";
                delete level;
            }
        }

    }
}

int LevelPackModel::rowCount(const QModelIndex &parent) const
{
    return m_levels.count();
}

QVariant LevelPackModel::data(const QModelIndex &index, int role) const
{
    if (index.row() < rowCount(index)) {
        LevelPack *level = m_levels[index.row()];
        if (level){
            if (role == IDRole)  {
                return level->levelId();
            } else if (role == NameRole)  {
                return level->levelName();
            } else if (role == DescriptionRole) {
                return level->levelDescription();
            } else if (role == NumLevelsRole) {
                return level->levelNumLevels();
            } else if (role == BackgroundImageRole) {
                return level->backgroundFilePath();
            }
        }
    }
    return QVariant();
}
