#include "LevelPack.h"
#include <QDebug>
#include <QFile>
#include <QTextStream>
#include <QFileInfo>

LevelPack::LevelPack(const QString &definition)
{
    m_definitionFilePath = definition;
    QFile definitionFile(m_definitionFilePath);

    if (!definitionFile.open(QIODevice::ReadOnly | QIODevice::Text)) {
        return;
    }

    QFileInfo info(definitionFile);
    m_baseDir = info.path();
    qDebug() << info.absoluteFilePath();

    QTextStream stream(&definitionFile);

    QString line;
    QString key;
    QString value;

    while (!stream.atEnd()) {
        line = stream.readLine();
        if (!line.trimmed().startsWith("#") && !line.isEmpty() && line.contains('=')) { //ignore comment, empty lines or lines not formatted correctly
            key = line.mid(0, line.indexOf("=")).trimmed();
            value = line.mid(line.indexOf("=") + 1).trimmed();

            qDebug() << key << "=" << value;

            if (key == "id") {
                m_id = value;
            } else if (key == "name") {
                m_name = value;
            } else if (key == "description") {
                m_description = value;
            } else if (key == "numlevels") {
                m_numLevels = value.toInt();
            } else if (key == "backgroundfile") {
                m_backgroundFilePath = value;
            }


        }
    }
    definitionFile.close();
}

bool LevelPack::valid()
{
    return !(m_baseDir.isEmpty() || m_name.isEmpty() || m_description.isEmpty() || m_numLevels==0 || m_backgroundFilePath.isEmpty()) ;
}

QString LevelPack::levelId()
{
    return m_id;
}

QString LevelPack::backgroundFilePath()
{
    return m_backgroundFilePath;
}

QString LevelPack::levelDescription()
{
    return m_description;
}

QString LevelPack::levelName()
{
    return m_name;
}

int LevelPack::levelNumLevels()
{
    return m_numLevels;
}
