#ifndef HELPER_H
#define HELPER_H

#include <QObject>
#include <QSettings>

#if defined(MEEGO_EDITION_HARMATTAN)
#include <qmsystem2/qmdisplaystate.h>
#endif

class Helper : public QObject
{
    Q_OBJECT
public:
    explicit Helper(QObject *parent = 0);

signals:

public slots:
    QString keyName(int keycode);

    QVariant getSetting(const QString &settingname, QVariant def);
    void setSetting(const QString& settingname, QVariant val);
    bool settingExists(const QString &settingname);

    //Pause the display blanking
    void setBlankingPause();

private:
    QSettings settings;

#if defined(MEEGO_EDITION_HARMATTAN)
    MeeGo::QmDisplayState *displayState;
#endif

};

#endif // HELPER_H
