#include "Helper.h"
#include <QApplication>
#include <QMetaEnum>

class StaticQtMetaObject : public QObject
{
public:
    static inline const QMetaObject& get() {return staticQtMetaObject;}
};

Helper::Helper(QObject *parent) :
    QObject(parent)
{
#if defined(MEEGO_EDITION_HARMATTAN)
    displayState = 0;
#endif
}

QString Helper::keyName(int keycode)
{
    int index = StaticQtMetaObject::get().indexOfEnumerator("Key");
    QMetaEnum metaEnum = StaticQtMetaObject::get().enumerator( index);
    QString keyString = metaEnum.valueToKey( keycode );
    return keyString.replace("Key_","");
    return QString();
}


QVariant Helper::getSetting(const QString &settingname, QVariant def)
{
    return settings.value("settings/" + settingname, def);
}

void Helper::setSetting(const QString &settingname, QVariant val)
{
    settings.setValue("settings/" + settingname, val);
}

bool Helper::settingExists(const QString &settingname)
{
    return settings.contains("settings/" + settingname);
}

void Helper::setBlankingPause()
{
#if defined(MEEGO_EDITION_HARMATTAN)
    if (!displayState) {
        displayState = new MeeGo::QmDisplayState(this);
    }
    displayState->setBlankingPause();
#endif
}
