#ifndef TRAILTRIPSEARCH_H
#define TRAILTRIPSEARCH_H

class QCheckBox;
class QPushButton;
class QLineEdit;
class QComboBox;
class TrailInterface;
class QVBoxLayout;

#include <QWidget>

class TrailTripSearch : public QWidget
{
    Q_OBJECT
public:
    explicit TrailTripSearch(TrailInterface *, QWidget *parent = 0);
    ~TrailTripSearch();

signals:

private slots:
    void slotSearch();

    void slotSearchTermClicked();
    void slotSearchProximityClicked();

private:
    QCheckBox *m_searchTerm;
    QCheckBox *m_searchNear;
    QPushButton *m_search;
    QLineEdit *m_searchString;
    QComboBox *m_searchProximity;

    QVBoxLayout *m_layout;
    TrailInterface *m_interface;
};

#endif // TRAILTRIPSEARCH_H
