#include "TrailTripSearch.h"
#include "trailinterface.h"

#include <QPushButton>
#include <QCheckBox>
#include <QComboBox>
#include <QLineEdit>
#include <QVBoxLayout>

TrailTripSearch::TrailTripSearch(TrailInterface *interface, QWidget *parent) :
    QWidget(parent)
{
    QStringList radius;

    radius << "5" << "10" << "15" << "20" << "25" << "40" << "50";

    m_interface = interface;

    m_searchTerm = new QCheckBox(tr("Search For:"), this);
    m_searchString = new QLineEdit(this);

    m_searchNear = new QCheckBox(tr("Search near current location"));
    m_searchProximity = new QComboBox(this);

    m_search = new QPushButton(tr("Search"));

    connect(m_searchTerm, SIGNAL(clicked()), this, SLOT(slotSearchTermClicked()));
    connect(m_searchNear, SIGNAL(clicked()), this, SLOT(slotSearchProximityClicked()));
    connect(m_search, SIGNAL(clicked()), this, SLOT(slotSearch()));

    m_searchTerm->setChecked(true);
    m_searchNear->setChecked(false);

    m_searchProximity->addItems(radius);

    m_layout = new QVBoxLayout(this);

    m_layout->addWidget(m_searchTerm);
    m_layout->addWidget(m_searchString);
    m_layout->addWidget(m_searchNear);
    m_layout->addWidget(m_searchProximity);
    m_layout->addWidget(m_search);
    m_layout->addStretch();

    setLayout(m_layout);
}

TrailTripSearch::~TrailTripSearch()
{


}

void TrailTripSearch::slotSearch()
{
    if (m_interface->location()) {
        m_interface->tripSearch(m_searchTerm->isChecked(), m_searchNear->isChecked(), m_searchString->text(), m_interface->location()->lastKnownPosition(), m_searchProximity->currentText());
    } else {
        QGeoPositionInfo pos;
        m_interface->tripSearch(m_searchTerm->isChecked(), m_searchNear->isChecked(), m_searchString->text(), pos, m_searchProximity->currentText());
    }
}

void TrailTripSearch::slotSearchTermClicked()
{
    m_searchString->setEnabled(m_searchTerm->isChecked());
}

void TrailTripSearch::slotSearchProximityClicked()
{
    m_searchProximity->setEnabled(m_searchNear->isChecked());
}

