TEMPLATE = app
TARGET = pgz-everytrail
DEPENDPATH += . \
INCLUDEPATH += . builddir

VERSION = 0.7.6
CONFIG += mobility12

SOURCES += main.cpp \
    s60trail.cpp \
    traillogin.cpp \
    trailinterface.cpp \
    trailmainmenu.cpp \
    trailtrip.cpp \
    trailtripslist.cpp \
    trailtripview.cpp \
    trailgpxrecorder.cpp \
    TrailTrackModel.cpp \
    TrailCreateTrip.cpp \
    formpost.cpp \
    TrailTripSearch.cpp \
    TrailGPXView.cpp \
    TripDelegate.cpp \
    MapWidget.cpp
HEADERS += s60trail.h \
    traillogin.h \
    trailinterface.h \
    trailmainmenu.h \
    trailtrip.h \
    trailtripslist.h \
    trailtripview.h \
    trailgpxrecorder.h \
    TrailTrackModel.h \
    TrailCreateTrip.h \
    formpost.h \
    TrailTripSearch.h \
    TrailGPXView.h \
    TripDelegate.h \
    MapWidget.h
OTHER_FILES += logo.jpg

RESOURCES += s60trail.qrc

QMAKE_LIBDIR += /opt/qtm12/lib

LIBS += -lQtNetwork \
    -lQtXml \
    -lQtLocation \

INCLUDEPATH += /usr/local/include \
               /usr/local/include/QtMobility \
               /opt/qtm12/include \
               /opt/qtm12/include/QtMobility \
               /usr/include/QtMobility

symbian {
    ICON = images/everytrail_1.svg

    #Use this uid when signing using custom certificate
    #TARGET.UID3 = 0xE656F302

    vendorinfo = \
    "%{\"Adam Pigg-EN\"}" \
    ":\"Adam Pigg\""

    # Remove all the existing platform dependencies
    default_deployment.pkg_prerules -= pkg_platform_dependencies

    #Add a dependency for just the S60 5th edition (Symbian^1) and later phones
    supported_platforms = \
    "; Application that only supports S60 5th edition" \
    "[0x1028315F],0,0,0,{\"S60ProductID\"}"

    my_deployment.pkg_prerules += supported_platforms
    my_deployment.pkg_prerules += vendorinfo
    DEPLOYMENT += my_deployment

    DEPLOYMENT.installer_header = 0x2002CCCF

    TARGET.CAPABILITY = LocalServices \
    NetworkServices \
    UserEnvironment \
    WriteUserData \
    ReadUserData
}


unix {
   maemo5 {
      desktop.path = /usr/share/applications/hildon
      icon.files += data/48x84/pgz-everytrail.png
   } else {
      desktop.path = /usr/share/applications
      icon.files += data/64x64/pgz-everytrail.png
   }

   INSTALLS += target desktop icon
   target.path = /usr/bin/  
   desktop.files += pgz-everytrail.desktop
   icon.path = /usr/share/pixmaps
}

include (installicons.pri)

