#include "TrailGPXView.h"
#include "MapWidget.h"

#include <QVBoxLayout>
#include <QDebug>

#include <QtLocation/QGeoServiceProvider>
#include <QtLocation/QGeoMappingManager>
#include <QtLocation/QGeoMapObject>
#include <QtLocation/QGeoBoundingBox>
#include <QtLocation/QGeoCoordinate>

#include <QGraphicsScene>
#include <QGraphicsView>

TrailGPXView::TrailGPXView(QWidget *parent) :
    QWidget(parent)
{
    m_layout = new QVBoxLayout();

    m_scene = new QGraphicsScene(this);
    m_qgv = new QGraphicsView(m_scene, this);
    m_qgv->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_qgv->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_qgv->setVisible(true);
    m_qgv->setInteractive(true);

    serviceProvider = new QtMobility::QGeoServiceProvider("nokia");
    manager = serviceProvider->mappingManager();

    m_mapView = new MapWidget(manager);
    m_mapView->setCenter(QtMobility::QGeoCoordinate(-27.0, 152.0));
    m_mapView->setZoomLevel(5);
    m_mapView->setMapType(QtMobility::QGraphicsGeoMap::TerrainMap);

    m_scene->addItem(m_mapView);

    m_layout->addWidget(m_qgv);
    setLayout(m_layout);
}

void TrailGPXView::addMapObject(QtMobility::QGeoMapObject *obj, bool fit)
{
    m_mapView->addMapObject(obj);

    if (fit) {
        m_mapView->fitInViewport(obj->boundingBox());
    }
}

void TrailGPXView::clearMapObjects()
{
    m_mapView->clearMapObjects();
}
