#ifndef TRAILGPXVIEW_H
#define TRAILGPXVIEW_H

#include <QWidget>
#include <QtLocation/QGeoMapObject>
#include <QtLocation/QGraphicsGeoMap>
#include <QtLocation/QGeoServiceProvider>
#include <QtLocation/QGeoMappingManager>
#include <QGraphicsScene>
#include <QGraphicsView>

class QWebView;
class QVBoxLayout;

class TrailGPXView : public QWidget
{
    Q_OBJECT
public:
    explicit TrailGPXView(QWidget *parent = 0);

    void addMapObject(QtMobility::QGeoMapObject*, bool fit);
    void clearMapObjects();

signals:

public slots:

private:
    QtMobility::QGraphicsGeoMap *m_mapView;

    QtMobility::QGeoServiceProvider *serviceProvider;
    QtMobility::QGeoMappingManager *manager;

    QGraphicsView *m_qgv;
    QGraphicsScene *m_scene;

    QVBoxLayout *m_layout;
};

#endif // TRAILGPXVIEW_H
