/*
 * This file is part of Personal GPRS Monitor.
 *
 * Copyright (C) 2009 Andrew Olmsted. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
*  
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/* personal-gprs-mon.h */

#ifndef _PERSONAL_GPRS_MON
#define _PERSONAL_GPRS_MON

#include <libhildondesktop/libhildondesktop.h>
#include <time.h> /* For tm. */

G_BEGIN_DECLS

#define PERSONAL_TYPE_GPRS_MON personal_gprs_mon_get_type()

#define PERSONAL_GPRS_MON(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), PERSONAL_TYPE_GPRS_MON, PersonalGprsMon))

#define PERSONAL_GPRS_MON_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), PERSONAL_TYPE_GPRS_MON, PersonalGprsMonClass))

#define PERSONAL_IS_GPRS_MON(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PERSONAL_TYPE_GPRS_MON))

#define PERSONAL_IS_GPRS_MON_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), PERSONAL_TYPE_GPRS_MON))

#define PERSONAL_GPRS_MON_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), PERSONAL_TYPE_GPRS_MON, PersonalGprsMonClass))

typedef struct _PersonalGprsMon        PersonalGprsMon;
typedef struct _PersonalGprsMonClass   PersonalGprsMonClass;
typedef struct _PersonalGprsMonPrivate PersonalGprsMonPrivate;

struct _PersonalGprsMon
{
  HDHomePluginItem parent;

  PersonalGprsMonPrivate *priv;
};

struct _PersonalGprsMonClass
{
  HDHomePluginItemClass  parent;
};

GType personal_gprs_mon_get_type (void);

G_END_DECLS

#endif /* _PERSONAL_GPRS_MON */

