# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *

class Field(QGraphicsObject):
    player = None
    original = None
    possible = False

    def __init__(self, parent = None, size = 0, x = 0, y = 0, maemo = False):
        QGraphicsObject.__init__(self, parent = parent)
        self.size = size
        self.place = (x, y)
        self.setPos(2 + self.size * x + 2 * x, 2 + self.size * y + 2 * y)

    def paint(self, painter, option, widget):
        painter.setPen(Qt.black)
        #if self.possible: painter.setBrush(Qt.yellow)
        #else: painter.setBrush(Qt.gray)
        painter.drawRoundedRect(0, 0, self.size, self.size, self.size/10, self.size/10)
        #painter.drawText(0, self.size, '%s-%s' % (self.place[0], self.place[1]))
        if self.player != None:
            if self.player: painter.setBrush(Qt.white)
            else: painter.setBrush(Qt.black)
            painter.drawEllipse(5, 5, self.size-10, self.size-10)

    def mousePressEvent(self, event):
        self.emit(SIGNAL("clicked"), self.place[0], self.place[1])

    def boundingRect(self):
        return QRectF(0, 0, self.size,  self.size)

    def starting(self, player = None):
        self.original = player
        self.set(player)

    def set(self, player = None):
        self.player = player
        self.update()

    def reset(self):
        self.player = self.original
        self.update()

    def isSet(self):
        return self.player != None

    def get(self):
        return self.player

    def setPossible(self, value):
        self.possible = value
