# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from player import Player
from random import randint

class ComputerRandom(Player):
    def __init__(self, table):
        Player.__init__(self, table)
        QObject.__init__(self, table)

    def activated(self):
        if not self.active: return False
        moves = self.table.getPosibleMoves().values()
        #print 'moves'
        #print moves
        while moves:
            randomMove = randint(0, len(moves)-1)
            #print 'random move %s' % randomMove
            #print moves[randomMove][0]
            if self.table.pick(moves[randomMove][0][0], moves[randomMove][0][1]):
                return True
            del moves[randomMove]
        return False