/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include <QPainter>
#include <QtCore>
#include "pppaper.h"

PPPaper::PPPaper(QGraphicsItem *parent) :
    QGraphicsObject(parent)
{
    m_dirty = false;
    m_background.setColor(Qt::white);
    m_nextId = 1;
}

QRectF PPPaper::boundingRect() const{
//    QRectF r;
//    QRectF cbr = childrenBoundingRect();
//    r = cbr.united(m_rect);
    return m_rect;
}

void PPPaper::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget){
//    Q_UNUSED(painter);
    Q_UNUSED(option);
    Q_UNUSED(widget);

    /*
    painter->save();
    QPen pen(Qt::NoPen);
    painter->setPen(pen);
//    QBrush brush(m_background.color());
    QBrush brush = m_background.brush();
    painter->setBrush(brush);

    QRectF rect = boundingRect();
    painter->drawRect(rect);

    painter->restore();*/

    QRectF rect = boundingRect();
    m_background.paint(painter,rect.toRect());
}

void PPPaper::clear(){

    PPBackground bg;
    bg.setColor(Qt::white);
    setBackground(bg);

    QList<QGraphicsItem *> items = childItems();
    foreach (QGraphicsItem *item ,items) {
        item->setParentItem(0);
        delete item;
    }

}

QRect PPPaper::rect() const {
    return m_rect;
}

void PPPaper::setRect(QRect val){
    prepareGeometryChange();
    m_rect = val;
}


void PPPaper::setDirty(bool val){
    m_dirty = val;
}

bool PPPaper::dirty(){
    return m_dirty;
}

void PPPaper::setBackground(PPBackground val){
    m_background = val;
    m_dirty = true;
    update();
}

PPBackground PPPaper::background(){
    return m_background;
}

int PPPaper::nextId(){
    return m_nextId;
}

QVariant PPPaper::itemChange(GraphicsItemChange change, const QVariant & value){
    if (change == QGraphicsItem::ItemChildAddedChange) {
        QGraphicsItem *item = value.value<QGraphicsItem *>();
        if (item) {
            PPGraphicsStroke *stroke = qgraphicsitem_cast<PPGraphicsStroke *>(item);
            if (stroke) {
                if (stroke->id() == 0){
                    stroke->setId(m_nextId++);
                } else {
                    m_nextId = qMax<int>(stroke->id() + 1, m_nextId);
                }
            }
        }
    }

    return QGraphicsObject::itemChange(change, value);
}
