#include <QtCore>
#include <QSqlRecord>
#include "pageentity.h"

PageEntity::PageEntity()
{
    m_bookId = -1;
}

PageEntity::PageEntity(const PageEntity& other) :
    Entity() {
    m_bookId = other.m_bookId;
    m_content = other.m_content;
    setId(other.id());
}

QString PageEntity::table() const{
    return "page";
}

void PageEntity::setBookId(int val){
    m_bookId = val;
}

int PageEntity::bookId(){
    return m_bookId;
}

void PageEntity::setContent(QString val){
   m_content = val;
}

QString PageEntity::content(){
    return m_content;
}

void PageEntity::reset(){
    setId(-1);
    m_bookId = -1;
    m_content = QString();
}

bool PageEntity::save(Storage* storage){
    int m_id = id();
    QString sql;
    QSqlQuery query = storage->query();

    if (m_id > 0) {
        sql = "REPLACE INTO page (id,bookId,content,creationDate,lastModifiedDate) values (:id,:bookId,:content,DATETIME('now'),DATETIME('now'));";
    } else {
        sql = "REPLACE INTO page (bookId,content,lastModifiedDate) values (:bookId,:content,DATETIME('now'));";
    }

    query.prepare(sql);
    if (m_id > 0)
        query.bindValue(":id",m_id);
    query.bindValue(":bookId",m_bookId);
    query.bindValue(":content",m_content);

    bool res = query.exec();
    if (res) {
        if (m_id <= 0)
            setId( query.lastInsertId().toInt() );
    } else {
        qDebug() << "Failed to execute" << query.executedQuery();
    }
    return res;
}

bool PageEntity::load(Storage* storage,int id){
    bool res = false;
    QSqlQuery query = storage->query();

    query.prepare("SELECT * from page where id = :id limit 1;");
    query.bindValue(":id",id);

    if (!query.exec()){
        qDebug() << "Failed to execute " << query.executedQuery();
    }

    if (query.next()) {
        QSqlRecord record = query.record();
        m_bookId = record.value("bookId").toInt();
        m_content = record.value("content").toString();
        setId(id);
        res = true;
    }

    return res;
}


QList<PageEntity> PageEntity::pagesOfBook(int bookId) {
    QString sql = "SELECT * from page where bookId = :bookId;";

    Storage *storage = Storage::instance();
    QSqlQuery query = storage->query();

    query.prepare(sql);
    query.bindValue(":bookId",bookId);

    query.exec();
    QList<PageEntity> result;

    while (query.next()) {
        QSqlRecord record = query.record();
//        qDebug() << record;
        int id = record.value("id").toInt();
        int bookId = record.value("bookId").toInt();
        QString content = record.value("content").toString();

        PageEntity entity;
        entity.setId(id);
        entity.setBookId(bookId);
        entity.setContent(content);

        result << entity;
    }

    return result;
}
