#include <QtCore>
#include <QApplication>
#include <QDesktopWidget>

#include "maemo5application.h"
#include "tables.h"
#include "pageeditorwindow.h"
#include "configentity.h"

Maemo5Application::Maemo5Application(QObject *parent) :
    QObject(parent)
{
    viewer = new PageViewerWindow();
    bookId = 1;
    connect(viewer,SIGNAL(requestNewPage()),
            this,SLOT(newPage()));
    connect(viewer,SIGNAL(requestOpenPage(int)),
            this,SLOT(openPage(int)));



#ifdef Q_WS_MAEMO_5
    viewer->setAttribute(Qt::WA_Maemo5StackedWindow);
    viewer->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    viewer->setWindowFlags(viewer->windowFlags() | Qt::Window);

    editor = new PageEditorWindow(viewer);
    editor->setAttribute(Qt::WA_Maemo5StackedWindow);
    editor->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    editor->setWindowFlags(editor->windowFlags() | Qt::Window);

    connect(QApplication::desktop(), SIGNAL(resized(int)),
            this, SLOT(setWinSize()));
#else
    editor = new PageEditorWindow();
    editor->setAttribute(Qt::WA_DeleteOnClose,false);
#endif

    connect(editor,SIGNAL(saved(int)),
            this,SLOT(onPageSaved(int)));
    connect(editor,SIGNAL(deleted(int)),
            this,SLOT(onPageDeleted(int)));

    setWinSize();
}

Maemo5Application::~Maemo5Application() {
}

int Maemo5Application::exec(){
    Storage *storage = Storage::instance();
    storage->open();

    BookEntity entity;
    if (!entity.load(storage,bookId)){ // Load default book
        entity.setId(bookId);
        entity.save(storage);// Create if it is missed.
    }

    viewer->show();
    viewer->open(bookId);

    ConfigEntity colorEntity;
    ConfigEntity brushTypeEntity;
    ConfigEntity backgroundColorEntity;

    colorEntity.load("pen-color","#000000");
    brushTypeEntity.load("pen-brush-type","2");
    backgroundColorEntity.load("background-color","#ffffff");

    QColor color(backgroundColorEntity.value());
    editor->setBackgroundColor(color);

    Drawpad *drawpad = editor->drawpad();
    drawpad->setColor(QColor(colorEntity.value()));
    drawpad->setBrushType(brushTypeEntity.value().toInt());

    setWinSize();

    int ret = qApp->exec();

    // On Quit.

    colorEntity.setValue(drawpad->color().name());
    QString val;
    val.setNum(drawpad->brushType());
    brushTypeEntity.setValue(val);
    backgroundColorEntity.setValue(editor->backgroundColor().name());

    // Save

    colorEntity.save();
    brushTypeEntity.save();
    backgroundColorEntity.save();

    return ret;
}

void Maemo5Application::newPage(){

    editor->newPage(bookId);
    editor->show();

}

void Maemo5Application::openPage(int pageId){


    editor->open(pageId);
    editor->show();

}


void Maemo5Application::onPageSaved(int pageId){
    viewer->append(pageId);
}

void Maemo5Application::onPageDeleted(int pageId){
    viewer->model()->remove(pageId);
}

void Maemo5Application::setWinSize(){
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    QSize thumbnail;
    QSize viewport;
    if (screenGeometry.width() > screenGeometry.height()) {
        thumbnail = QSize(180,80);
        viewport = QSize(800,480 - 130);
    } else {
        thumbnail = QSize(128,180);
        viewport = QSize(480,800 - 130);
    }

    viewer->setThumbnailSize(thumbnail);
    editor->setViewportSize(viewport);

}
