#include <QGraphicsSceneMouseEvent>
#include <QGraphicsScene>
#include <QtCore>
#include "eraser.h"
#include "xmlioiface.h"

Eraser::Eraser(QGraphicsItem *parent) :
    QGraphicsObject(parent)
{
    m_canvas = 0;
}

void Eraser::paint( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget ) {
    Q_UNUSED(painter);
    Q_UNUSED(option);
    Q_UNUSED(widget);
}

QRectF Eraser::boundingRect() const{
    return QRectF();
}

void Eraser::start(QGraphicsItem* canvas){
    stop();
    m_canvas = canvas;
    canvas->installSceneEventFilter(this);
}

void Eraser::stop(){
    if (m_canvas){
        m_canvas->removeSceneEventFilter(this);
        m_canvas = 0;
    }
}


bool Eraser::sceneEventFilter ( QGraphicsItem * watched, QEvent * event){

    bool handled = false;
    if (event->type() == QEvent::GraphicsSceneMousePress
        || event->type() == QEvent::GraphicsSceneMouseMove
        || event->type() == QEvent::GraphicsSceneMouseRelease
        ) {
        QGraphicsSceneMouseEvent* mouseEvent = static_cast< QGraphicsSceneMouseEvent *>(event);
        QGraphicsScene *s = scene();

        QPointF pt = watched->mapToScene( mouseEvent->pos() );

        int margin = 15;
        QRectF rect(pt.x(),pt.y(),margin,margin);
        rect.moveCenter(pt);

        QList<QGraphicsItem *> items = s->items(rect,Qt::IntersectsItemShape	);

        int eraseCount = 0;

        foreach (QGraphicsItem *item , items){
            if (item == watched)
                continue;
            XmlIOIface* sketchItem = dynamic_cast<XmlIOIface *>(item);
            if (sketchItem) {
//                qDebug() << "Found sketch item" << sketchItem->tagName();
                eraseCount++;
                delete item;
            }
//            delete item;
        }

        if (eraseCount)
            emit erased();
        handled = true;
    }

    if (handled)
        return handled;
    return QGraphicsObject::sceneEventFilter(watched,event);
}
