/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#ifndef MAEMO5PAPERBACKGROUNDDIALOG_H
#define MAEMO5PAPERBACKGROUNDDIALOG_H

#include <QDialog>
#include "paperbackground.h"

namespace Ui {
    class Maemo5PaperBackgroundDialog;
}

class Maemo5PaperBackgroundDialog : public QDialog
{
    Q_OBJECT

public:
    explicit Maemo5PaperBackgroundDialog(QWidget *parent = 0);
    ~Maemo5PaperBackgroundDialog();

    void setColor(QColor val);
    QColor color();

    /// The selected background
    PaperBackground selectBackground();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::Maemo5PaperBackgroundDialog *ui;

    /// Last selected color
    QColor m_color;

private slots:
    void on_colorButton_clicked();
    void on_confirmButton_clicked();
};

#endif // MAEMO5PAPERBACKGROUNDDIALOG_H
