#include <QtCore>
#include <QPainter>
#include <QBuffer>
#include <QPixmap>
#include "page.h"
#include "pageentity.h"
#include "snapshotentity.h"
#include "tables.h"

Page::Page(QObject *parent) :
    QObject(parent)
{
}

/* Standard Page */
StandardPage::StandardPage(QObject *parent ) : Page(parent){
    m_content = 0;
    defaultRect = QRect(0,0,1600,1600);

}

StandardPage::~StandardPage(){
    if (m_content->parent() == 0 && m_content->parentItem() == 0)
        m_content->deleteLater();
}

void StandardPage::newPage(int bookId) {
    clear();
    m_entity.setBookId(bookId);
}

bool StandardPage::load(int pageId) {
    clear();

    if (pageId < 0 ) {
        m_entity.setId(pageId);
        m_entity.setContent("");
        return true;
    }

    bool res = m_entity.load(Storage::instance() , pageId);

    if (res) {
        QDomDocument doc;
        doc.setContent(m_entity.content());
        setFromXml(doc);
    } else {
        qDebug() << "StandardPage failed to load page with ID " << pageId;
    }

    return res;
}

bool StandardPage::save(Paper *paper) {

    // Save page
    QDomDocument doc = toXml();
    m_entity.setContent(doc.toString(-1));
    bool res = m_entity.save(Storage::instance());

    // Snapshot
    QPixmap snapshot(200,168);
    snapshot.fill(QColor(255,255,255,255));

    QPainter painter(&snapshot);
    QRectF target(0,0,200,168);
    paper->snapshot(&painter,target);
    painter.end();

    QBuffer buffer;
    buffer.open(QIODevice::ReadWrite);
    snapshot.save(&buffer,"PNG");
    buffer.seek(0);

    SnapshotEntity snapshotEntity;
    snapshotEntity.find(m_entity.id());
    snapshotEntity.setContent(buffer.readAll());
    snapshotEntity.save();
    buffer.close();
    return res;
}

void StandardPage::clear(){
    m_entity.reset();

    Paper* paper = content();
    QList<QGraphicsItem *> items = paper->childItems();
    foreach (QGraphicsItem *item ,items) {
        delete item;
    }
    paper->setRect(defaultRect);

}

void StandardPage::remove(){

    if (m_entity.id() > 0) { // It is not save.

        SnapshotEntity snapshotEntity;
        if (snapshotEntity.find(m_entity.id())){
            snapshotEntity.remove();
        }

        m_entity.remove();
    }

    clear();

}

bool StandardPage::setFromXml(QDomDocument &doc){
//    qDebug() << __func__ << doc.toString();
    QDomElement page = doc.firstChildElement("page");
    if (page.isNull())
        return false;

    QDomElement contentElem = page.firstChildElement("content");
    if (contentElem.isNull())
        return false;

    QDomElement paperElem = contentElem.firstChildElement("paper");
    Paper *paper = content();

    // Remove all children
    QList<QGraphicsItem *> items = paper->childItems();
    foreach (QGraphicsItem *item ,items) {
        delete item;
    }

    paper->setFromElement(paperElem);

    return true;
}

QDomDocument StandardPage::toXml() {
    QDomDocument doc;
    QDomElement page = doc.createElement("page");
    doc.appendChild(page);
    page.setAttribute("type","standard");

    QDomElement title = doc.createElement("title");
    page.appendChild(title);

    QDomElement contentElem = doc.createElement("content");
    page.appendChild(contentElem);

    Paper* paper = content();
    QDomElement paperElem = paper->createElement(doc);
    contentElem.appendChild(paperElem);

    return doc;
}

Paper* StandardPage::content(){
    if (!m_content) {
        m_content = new SketchPaper();
        if (m_entity.id() > 0 ) {
            QDomDocument doc;
            doc.setContent(m_entity.content());
            QDomElement contentNode = doc.firstChildElement("content");
            QDomElement paperNode = contentNode.firstChildElement("paper");
            m_content->setFromElement(paperNode);
        }
    }
    return m_content;
}

PageEntity *StandardPage::entity(){
    return &m_entity;
}
