#include <QEvent>
#include <QtCore>
#include <QGraphicsSceneMouseEvent>
#include "strokerecorder.h"

StrokeRecorder::StrokeRecorder(QGraphicsItem *parent) :
    QGraphicsObject(parent)
{
    canvas = 0;
    stroke = 0;

    m_pen.setColor(Qt::red);
    m_pen.setStyle(Qt::SolidLine);
    m_pen.setWidth(3);
}

void StrokeRecorder::record(QGraphicsItem* canvas){
    stop();

    this->canvas = canvas;
    canvas->installSceneEventFilter(this);
}

void StrokeRecorder::paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget ){
    Q_UNUSED(painter);
    Q_UNUSED(option);
    Q_UNUSED(widget);
}

QRectF StrokeRecorder::boundingRect() const{
    return QRectF();
}


void StrokeRecorder::stop(){
    if (canvas)
        canvas->removeSceneEventFilter(this);
    stroke =0;
}

void StrokeRecorder::setPen(QPen &pen){
    m_pen = pen;
}

QPen StrokeRecorder::pen(){
    return m_pen;
}

bool StrokeRecorder::sceneEventFilter ( QGraphicsItem * watched, QEvent * event){
    bool handled = false;
    QGraphicsSceneMouseEvent *mouseEvent;
    if (watched == canvas) {
        if (event->type() == QEvent::GraphicsSceneMousePress ||
            event->type() == QEvent::GraphicsSceneMouseDoubleClick
            ) {
            mouseEvent = static_cast< QGraphicsSceneMouseEvent *>(event);
            stroke = new GraphicsStroke(watched);
            stroke->setPen(m_pen);
            stroke->append(mouseEvent->pos());
            stroke->append(mouseEvent->pos());
            handled = true;

        } else if (event->type() == QEvent::GraphicsSceneMouseRelease ) {
            mouseEvent = static_cast< QGraphicsSceneMouseEvent *>(event);
            stroke->append(mouseEvent->lastPos());
            stroke->append(mouseEvent->pos());
            handled = true;

            canvas->removeSceneEventFilter(this);
            stroke = 0;
            emit recorded();

        } else if (event->type() == QEvent::GraphicsSceneMouseMove ) {
            mouseEvent = static_cast< QGraphicsSceneMouseEvent *>(event);

            stroke->append(mouseEvent->lastPos());
            stroke->append(mouseEvent->pos());
            handled = true;

        }
    }

    if (!handled)
        return QGraphicsObject::sceneEventFilter(watched,event);
    return handled;
}
