#ifndef PENGUINTVFEEDBUNDLE_H
#define PENGUINTVFEEDBUNDLE_H

#include "feedinterface.h"

#include <QSqlDatabase>
#include <QVector>

class PenguinTvFeedBundle;

class PenguinTvFeed : public IFeed
{
public:
    // IFeed
    void getEntries( QVector<FeedEntry>& entries) const;
    QString name() const;

    void decorate(QListWidgetItem*) const;

    // others
    void setName(const QString& name);

    int m_feedid;
    int m_newatlast;

    PenguinTvFeedBundle* m_feedbundle;

private:
    QString m_name;
};

class PenguinTvFeedBundle : public IFeedBundle
{
public:
    PenguinTvFeedBundle();
    ~PenguinTvFeedBundle();
    // IFeed
    void getFeeds(QVector< IFeed* >& feeds);

    bool readDatabase();
    QSqlDatabase& db() { return m_db; }

private:
    QSqlDatabase m_db;
    QVector<PenguinTvFeed*> m_feeds;
};

#endif // PENGUINTVFEEDBUNDLE_H
