#include "textedithelper.h"

#include <QTextEdit>
#include <QTextCursor>
#include <QScrollBar>


TextEditHelper::TextEditHelper(QTextEdit& editor) : e(editor)
{
}

void TextEditHelper::partialPageUpDown(QTextCursor::MoveOperation op)
{
    QTextCursor crs = e.textCursor();
    QRect crect = e.cursorRect();
    QScrollBar* vbar = e.verticalScrollBar();
    int pstep = vbar->pageStep();
    int newstep = pstep - e.fontMetrics().xHeight() * 2;
    vbar->setPageStep(newstep);

    QAbstractSlider::SliderAction sliderop = (op == QTextCursor::Up ? QAbstractSlider::SliderPageStepSub : QAbstractSlider::SliderPageStepAdd);
    vbar->triggerAction(sliderop);
    vbar->setPageStep(pstep);

    // retain cursor at same pos

    QTextCursor newcrs = e.cursorForPosition(crect.topLeft());
    e.setTextCursor(newcrs);
}
void TextEditHelper::cursorToCenter()
{
    QRect vpr = e.viewport()->rect();
    QPoint p = vpr.center();
    p.setX(0);

    QTextCursor crs = e.cursorForPosition(p);
    e.setTextCursor(crs);
}
