#ifndef PENGUINUI_H
#define PENGUINUI_H

#include <QtGui/QStackedWidget>
#include <QtGui/QListWidget>
#include <QMap>
#include <QUrl>

class IFeedBundle;

class PrFeedView;
class PrTextBody;

class QListWidgetItem;
class IFeed;
class FeedRenderer;
class QStringList;
class PrAppServices;

class PrTopStackedWidget : public QStackedWidget
{
    Q_OBJECT
public:
    PrTopStackedWidget(QWidget *parent, PrAppServices* appsrv);
    ~PrTopStackedWidget();

    // will clear curent feed bundle if any
    void setFeedBundle(IFeedBundle* feeds);
    void setRenderer(FeedRenderer* renderer);

    FeedRenderer* renderer() { return m_renderer; };

    PrTextBody* bodyWdg();
    PrFeedView* feedWdg();
    QStringList urlList();
    bool linksEnabled();

public slots:
    void showFeed(QListWidgetItem* item);
    void urlClicked(const QUrl & link );

protected:
    void changeEvent(QEvent *e);
    void keyPressEvent(QKeyEvent *e);

private:
    PrFeedView* m_FeedView;
    PrTextBody* m_TextBody;
    PrAppServices* m_appSrv;
    QUrl m_baseUrl;

    QMap< QListWidgetItem*, const IFeed*> m_feedmap;

    IFeedBundle* m_feedbundle;
    FeedRenderer* m_renderer;
    QListWidgetItem* m_currentItem;
    QStringList m_urlList;
    //Ui::PrTopStackedWidget *m_ui;
    bool m_linksEnabled;
};

#endif // PENGUINUI_H
