#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "prappservices.h"

class QAction;
class QMenu;
class QTextEdit;

class PrTopStackedWidget;
class PenguinTvFeedBundle;
class IFeedBundle;
class FeedRenderer;

//! [0]
class MainWindow : public QMainWindow, public PrAppServices
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();

    // from PrAppServices

    QSettings* settings();
    void launchUrl(const QUrl& url);



protected:
    //void closeEvent(QCloseEvent *event);

private slots:

    void zoomInPressed();
    void zoomOutPressed();


    // PenguinTV stuff
    void setupPenguinTvFeeds();
    void doReadDatabase();

    // file system reader
    void setupFilesystemFeeds();

    void about();
    void showHelp();

    void changeOrientation();

private:
    void createActions();
    void createMenus();

    QMenu *helpMenu;
    QAction *aboutAct;
    QAction *aboutQtAct;
    QAction *helpAct;

    PrTopStackedWidget* m_topWdg;
    IFeedBundle* m_feedBundle;
    FeedRenderer* m_renderer;
    QSettings* m_settings;
};

#endif
