#include "fingerbuttondialog.h"
#include "ui_fingerbuttondialog.h"
#include <QDebug>

FingerButtonDialog::FingerButtonDialog(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::FingerButtonDialog)
{
    m_ui->setupUi(this);
    m_signalMapper = new QSignalMapper(this);

    connect(m_ui->cancelButton, SIGNAL(clicked()), this, SLOT(reject()));
    m_selection = -1;

}

FingerButtonDialog::~FingerButtonDialog()
{
    delete m_ui;    
}

void FingerButtonDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void FingerButtonDialog::setButtons(const QStringList& texts)
{

     QGridLayout *gridLayout = m_ui->gridLayout;

     for (int i = 0; i < texts.size(); ++i) {
         QPushButton *button = new QPushButton(texts[i], this);
         m_widgets.append(button);
         connect(button, SIGNAL(clicked()), m_signalMapper, SLOT(map()));
         m_signalMapper->setMapping(button, i);
         gridLayout->addWidget(button, i / 2, i % 2);
     }

     connect(m_signalMapper, SIGNAL(mapped(int)),
             this, SLOT(clicked(int)));
}

void FingerButtonDialog::clicked(int buttonindex)
{
    qDebug("%i",buttonindex);
    m_selection = buttonindex;
    accept();

}

int FingerButtonDialog::selectedIndex() const
{
    return m_selection;
}

QWidget* FingerButtonDialog::widgetAt(int i)
{
    return m_widgets[i];
}
