#include "main.h"

#ifdef USE_SOUND
#include <SDL_mixer.h>
Mix_Chunk 
    *SNDClick, 
    *SNDBombExpl, 
    *SNDCityBonus, 
    *SNDCityNew, 
    *SNDCityNuked, 
    *SNDGameOver, 
    *SNDMissileBonus,
    *SNDMissileExpl,
    *SNDMissileFire,
    *SNDSwitchBase, 
    *SNDUfo1, 
    *SNDUfo2; 
Mix_Music *Music[MUSICNUM];
char ModName[MUSICNUM][20] =
{ // ARNIM - Try to find a few more non-suck songs
    "icefront.s3m", 
    "datajack.s3m", 
    "spirits_talking.s3m",
};

int sound = 1;
#else
int sound = 0;
void 
    *SNDClick, 
    *SNDBombExpl, 
    *SNDCityBonus, 
    *SNDCityNew, 
    *SNDCityNuked, 
    *SNDGameOver, 
    *SNDMissileBonus,
    *SNDMissileExpl,
    *SNDMissileFire,
    *SNDSwitchBase, 
    *SNDUfo1, 
    *SNDUfo2; 
void *Music[MUSICNUM];
#endif
int CurrentMusic = 0;

void
PlayMusic()
{
#ifdef USE_SOUND
    if (!sound)
        return;

    CurrentMusic = abrand(0, MUSICNUM - 1);
    printf("Now playing song #%d\n", CurrentMusic);
    if ((!Mix_PlayingMusic()) && sound)
        Mix_PlayMusic(Music[CurrentMusic], 1);
#endif
}

void
SetVol()
{
#ifdef USE_SOUND
    if (!sound)
        return;
    // ARNIM - New Sounds Need Tweaking 
    SNDClick->volume = SoundVol * 5;
    SNDBombExpl->volume = SoundVol * 8;
    SNDCityBonus->volume = SoundVol * 4;
    SNDCityNew->volume = SoundVol * 12;
    SNDCityNuked->volume = SoundVol * 12;
    SNDGameOver->volume = SoundVol * 6;
    SNDMissileBonus->volume = SoundVol * 2;
    SNDMissileExpl->volume = SoundVol * 7;
    SNDMissileFire->volume = SoundVol * 1;
    SNDSwitchBase->volume = SoundVol * 7;
    SNDUfo1->volume = SoundVol * 4;
    SNDUfo2->volume = SoundVol * 4;
    Mix_VolumeMusic(MusicVol * 10);
#endif
}

void
InitSound()
{
#ifdef USE_SOUND
    int i, ChannelNum;
    char text[200];

    if (!sound)
        return;
    puts("** Opening Audio Mixer **");
    if (Mix_OpenAudio(MIX_DEFAULT_FREQUENCY, MIX_DEFAULT_FORMAT, 2, 1024) < 0) { //ARNIM 2048-1024
        fprintf(stderr, "Warning: Couldn't set 44100 Hz audio\n- Reason: %s\n", SDL_GetError());
        fprintf(stderr, "\t**\nSOUND TURNED OFF\n\t**\n");
        sound = 0;
    } else {
        ChannelNum = Mix_AllocateChannels(9) - 1;
        printf("   %d channels allocated\n", ChannelNum);
        if (ChannelNum > 2)
            Mix_ReserveChannels(1);
        printf("** Loading Music **\n");
        for (i = 0; i < MUSICNUM; i++) {
            sprintf(text, "%s/sound/%s", DATAPATH, ModName[i]);
            Music[i] = Mix_LoadMUS(text);
            if (Music == NULL)
                printf("COULD NOT LOAD MUSIC: %s\n", SDL_GetError());
        }
        printf("** Loading Sounds **\n");
        sprintf(text, "%s/sound/%s", DATAPATH, "click.wav");
        SNDClick = Mix_LoadWAV(text);
        if (SNDClick == NULL) {
            puts("Sound effects could not be loaded. FATAL ERROR!");
            exit(1);
        }
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_bomb_expl.wav");
        SNDBombExpl= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_city_bonus.wav");
        SNDCityBonus= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_city_new.wav");
        SNDCityNew= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_city_nuked.wav");
        SNDCityNuked= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_game_over.wav");
        SNDGameOver= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_missile_bonus.wav");
        SNDMissileBonus= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_missile_expl.wav");
        SNDMissileExpl= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_missile_fire.wav");
        SNDMissileFire= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_switch_base.wav");
        SNDSwitchBase= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_ufosound_loop.wav");
        SNDUfo1= Mix_LoadWAV(text);
        sprintf(text, "%s/sound/%s", DATAPATH, "pup_ufosound_orig.wav");
        SNDUfo2= Mix_LoadWAV(text);
        
        Mix_HookMusicFinished(PlayMusic);
    }
    CurrentMusic = abrand(0, MUSICNUM - 1);
#endif
}

void
PlaySound(Mix_Chunk * Sample)
{
#ifdef USE_SOUND
    if (sound) {
//      printf("Playing on channel %d\n",Mix_PlayChannel(-1,Sample,0));
        Mix_PlayChannel(-1, Sample, 0);
    }
#endif
}
